/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.naming.StringUtils;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.util.NumberUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Slf4JOutputWriter
extends BaseOutputWriter {
    private final Logger logger;

    @JsonCreator
    public Slf4JOutputWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="logger") String logger, @JsonProperty(value="settings") Map<String, Object> settings) {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        String loggerName = (String)MoreObjects.firstNonNull((Object)logger, (Object)"jmxtrans.output");
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    @VisibleForTesting
    Slf4JOutputWriter(Logger logger) {
        super(ImmutableList.of(), true, Boolean.valueOf(false), new HashMap());
        this.logger = logger;
    }

    protected void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        ImmutableList typeNames = this.getTypeNames();
        for (Result result : results) {
            ImmutableMap resultValues = result.getValues();
            if (resultValues == null) continue;
            for (Map.Entry<String, Object> values : resultValues.entrySet()) {
                this.logValue(server, query, (List<String>)typeNames, result, values);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logValue(Server server, Query query, List<String> typeNames, Result result, Map.Entry<String, Object> values) throws IOException {
        Object value = values.getValue();
        if (value != null && NumberUtils.isNumeric((Object)value)) {
            Closer closer = Closer.create();
            try {
                closer.register((Closeable)MDC.putCloseable((String)"server", (String)this.computeAlias(server)));
                closer.register((Closeable)MDC.putCloseable((String)"metric", (String)KeyUtils.getKeyString((Server)server, (Query)query, (Result)result, values, typeNames, null)));
                closer.register((Closeable)MDC.putCloseable((String)"value", (String)value.toString()));
                if (result.getKeyAlias() != null) {
                    closer.register((Closeable)MDC.putCloseable((String)"resultAlias", (String)result.getKeyAlias()));
                }
                closer.register((Closeable)MDC.putCloseable((String)"attributeName", (String)result.getAttributeName()));
                closer.register((Closeable)MDC.putCloseable((String)"key", (String)values.getKey()));
                closer.register((Closeable)MDC.putCloseable((String)"epoch", (String)String.valueOf(result.getEpoch())));
                this.logger.info("");
            }
            catch (Throwable t) {
                closer.rethrow(t);
            }
            finally {
                closer.close();
            }
        }
    }

    private String computeAlias(Server server) {
        if (server.getAlias() != null) {
            return server.getAlias();
        }
        return StringUtils.cleanupStr((String)(server.getHost() + "_" + server.getPort()));
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
    }
}

