/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.OutputWriterAdapter;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.output.support.WriterBasedOutputWriter;
import com.googlecode.jmxtrans.model.output.support.pool.SocketAllocator;
import com.googlecode.jmxtrans.model.output.support.pool.SocketExpiration;
import com.googlecode.jmxtrans.model.output.support.pool.SocketPoolable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import stormpot.Allocator;
import stormpot.BlazePool;
import stormpot.Config;
import stormpot.Expiration;
import stormpot.LifecycledPool;
import stormpot.Timeout;

public class TcpOutputWriter<T extends WriterBasedOutputWriter>
extends OutputWriterAdapter {
    @Nonnull
    private final T target;
    @Nonnull
    private final LifecycledPool<SocketPoolable> socketPool;

    public TcpOutputWriter(@Nonnull T target, @Nonnull LifecycledPool<SocketPoolable> socketPool) {
        this.target = target;
        this.socketPool = socketPool;
    }

    public void doWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        try {
            SocketPoolable socketPoolable = (SocketPoolable)this.socketPool.claim(new Timeout(1L, TimeUnit.SECONDS));
            try {
                this.target.write(socketPoolable.getWriter(), server, query, results);
            }
            catch (IOException ioe) {
                socketPoolable.invalidate();
                throw ioe;
            }
            finally {
                socketPoolable.release();
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Could not get socket from pool, please check is the server is available");
        }
    }

    public void stop() throws LifecycleException {
        this.socketPool.shutdown();
    }

    public static <T extends WriterBasedOutputWriter> Builder<T> builder(@Nonnull InetSocketAddress server, @Nonnull T target) {
        return new Builder<T>(server, target);
    }

    public static class Builder<T extends WriterBasedOutputWriter> {
        @Nonnull
        private final InetSocketAddress server;
        @Nonnull
        private final T target;
        @Nonnull
        private Charset charset = Charsets.UTF_8;
        private int socketTimeoutMillis = 200;
        private int poolSize = 1;

        public Builder(@Nonnull InetSocketAddress server, @Nonnull T target) {
            this.server = server;
            this.target = target;
        }

        public TcpOutputWriter<T> build() {
            Config config = new Config().setAllocator((Allocator)new SocketAllocator(this.server, this.socketTimeoutMillis, this.charset)).setExpiration((Expiration)new SocketExpiration()).setSize(this.poolSize);
            BlazePool pool = new BlazePool(config);
            return new TcpOutputWriter<T>(this.target, (LifecycledPool<SocketPoolable>)pool);
        }

        public Builder<T> setCharset(@Nonnull Charset charset) {
            if (charset == null) {
                throw new NullPointerException("charset");
            }
            this.charset = charset;
            return this;
        }

        public Builder<T> setSocketTimeoutMillis(int socketTimeoutMillis) {
            this.socketTimeoutMillis = socketTimeoutMillis;
            return this;
        }

        public Builder<T> setPoolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }
    }
}

