/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.io.Closer;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.output.GraphiteWriter2;
import com.googlecode.jmxtrans.model.output.support.WriterBasedOutputWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Nonnull;

public class SensuWriter2
implements WriterBasedOutputWriter {
    @Nonnull
    private final GraphiteWriter2 graphiteWriter;
    @Nonnull
    private final JsonFactory jsonFactory;

    public SensuWriter2(@Nonnull GraphiteWriter2 graphiteWriter, @Nonnull JsonFactory jsonFactory) {
        this.graphiteWriter = graphiteWriter;
        this.jsonFactory = jsonFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@Nonnull Writer writer, @Nonnull Server server, @Nonnull Query query, @Nonnull Iterable<Result> results) throws IOException {
        Closer closer = Closer.create();
        try {
            JsonGenerator g = (JsonGenerator)closer.register((Closeable)this.jsonFactory.createGenerator(writer));
            g.useDefaultPrettyPrinter();
            g.writeStartObject();
            g.writeStringField("name", "jmxtrans");
            g.writeStringField("type", "metric");
            g.writeStringField("handler", "graphite");
            StringWriter temporaryWriter = (StringWriter)closer.register((Closeable)new StringWriter());
            this.graphiteWriter.write(temporaryWriter, server, query, results);
            g.writeStringField("output", temporaryWriter.toString());
            g.writeEndObject();
            g.flush();
        }
        catch (Throwable t) {
            closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }
}

