/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.output.StatsDWriter2;
import com.googlecode.jmxtrans.model.output.support.UdpOutputWriterBuilder;
import com.googlecode.jmxtrans.model.output.support.WriterPoolOutputWriter;
import java.net.InetSocketAddress;
import java.util.List;
import javax.annotation.Nonnull;

public class StatsDWriterFactory
implements OutputWriterFactory {
    @Nonnull
    private final ImmutableList<String> typeNames;
    @Nonnull
    private final String rootPrefix;
    private final boolean stringsValuesAsKey;
    @Nonnull
    private final String bucketType;
    @Nonnull
    private final Long stringValueDefaultCount;
    @Nonnull
    private final InetSocketAddress server;

    public StatsDWriterFactory(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="rootPrefix") String rootPrefix, @JsonProperty(value="bucketType") String bucketType, @JsonProperty(value="stringValuesAsKey") boolean stringsValuesAsKey, @JsonProperty(value="stringValueDefaultCount") Long stringValueDefaultCount, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port) {
        this.typeNames = (ImmutableList)MoreObjects.firstNonNull(typeNames, (Object)ImmutableList.of());
        this.rootPrefix = (String)MoreObjects.firstNonNull((Object)rootPrefix, (Object)"servers");
        this.stringsValuesAsKey = stringsValuesAsKey;
        this.bucketType = (String)MoreObjects.firstNonNull((Object)bucketType, (Object)"c");
        this.stringValueDefaultCount = (Long)MoreObjects.firstNonNull((Object)stringValueDefaultCount, (Object)1L);
        this.server = new InetSocketAddress((String)Preconditions.checkNotNull((Object)host, (Object)"Host cannot be null."), (int)((Integer)Preconditions.checkNotNull((Object)port, (Object)"Port cannot be null.")));
    }

    public WriterPoolOutputWriter<StatsDWriter2> create() {
        return UdpOutputWriterBuilder.builder(this.server, new StatsDWriter2((List<String>)this.typeNames, this.rootPrefix, this.bucketType, this.stringsValuesAsKey, this.stringValueDefaultCount)).setCharset(Charsets.UTF_8).build();
    }
}

