/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import com.googlecode.jmxtrans.model.OutputWriterAdapter;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.output.support.HttpUrlConnectionConfigurer;
import com.googlecode.jmxtrans.model.output.support.WriterBasedOutputWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpOutputWriter<T extends WriterBasedOutputWriter>
extends OutputWriterAdapter {
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger(HttpOutputWriter.class);
    @Nonnull
    private final T target;
    @Nonnull
    private final URL url;
    @Nullable
    private final Proxy proxy;
    @Nonnull
    private final HttpUrlConnectionConfigurer configurer;
    @Nonnull
    private final Charset charset;

    public HttpOutputWriter(@Nonnull T target, @Nonnull URL url, @Nullable Proxy proxy, @Nonnull HttpUrlConnectionConfigurer configurer, @Nullable Charset charset) {
        this.target = target;
        this.url = url;
        this.proxy = proxy;
        this.configurer = configurer;
        this.charset = (Charset)MoreObjects.firstNonNull((Object)charset, (Object)Charsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWrite(Server server, Query query, Iterable<Result> results) throws IOException {
        HttpURLConnection httpURLConnection = this.createHttpURLConnection();
        try {
            this.configurer.configure(httpURLConnection);
            this.writeResults(server, query, results, httpURLConnection);
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode != 200) {
                this.logger.warn("Failure {}:'{}' to send result to server '{}' with proxy {}", new Object[]{responseCode, httpURLConnection.getResponseMessage(), this.url, this.proxy});
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(IOUtils.toString((InputStream)httpURLConnection.getInputStream()));
            }
        }
        finally {
            this.consumeInputStreams(httpURLConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeInputStreams(HttpURLConnection httpURLConnection) throws IOException {
        Closer closer = Closer.create();
        try {
            InputStream in = (InputStream)closer.register((Closeable)httpURLConnection.getInputStream());
            InputStream err = (InputStream)closer.register((Closeable)httpURLConnection.getErrorStream());
            ByteStreams.copy((InputStream)in, (OutputStream)ByteStreams.nullOutputStream());
            if (err != null) {
                ByteStreams.copy((InputStream)err, (OutputStream)ByteStreams.nullOutputStream());
            }
        }
        catch (Throwable t) {
            closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResults(Server server, Query query, Iterable<Result> results, HttpURLConnection httpURLConnection) throws IOException {
        Closer closer = Closer.create();
        try {
            OutputStreamWriter outputStream = (OutputStreamWriter)closer.register((Closeable)new OutputStreamWriter(httpURLConnection.getOutputStream(), this.charset));
            this.target.write(outputStream, server, query, results);
        }
        catch (Throwable t) {
            closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    private HttpURLConnection createHttpURLConnection() throws IOException {
        if (this.proxy == null) {
            return (HttpURLConnection)this.url.openConnection();
        }
        return (HttpURLConnection)this.url.openConnection(this.proxy);
    }
}

