/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support;

import com.google.common.base.Charsets;
import com.googlecode.jmxtrans.model.output.support.WriterBasedOutputWriter;
import com.googlecode.jmxtrans.model.output.support.WriterPoolOutputWriter;
import com.googlecode.jmxtrans.model.output.support.pool.SocketAllocator;
import com.googlecode.jmxtrans.model.output.support.pool.SocketExpiration;
import com.googlecode.jmxtrans.model.output.support.pool.SocketPoolable;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import stormpot.Allocator;
import stormpot.BlazePool;
import stormpot.Config;
import stormpot.Expiration;
import stormpot.LifecycledPool;
import stormpot.Timeout;

public class TcpOutputWriterBuilder<T extends WriterBasedOutputWriter> {
    @Nonnull
    private final InetSocketAddress server;
    @Nonnull
    private final T target;
    @Nonnull
    private Charset charset = Charsets.UTF_8;
    private int socketTimeoutMillis = 200;
    private int poolSize = 1;

    private TcpOutputWriterBuilder(@Nonnull InetSocketAddress server, @Nonnull T target) {
        this.server = server;
        this.target = target;
    }

    public static <T extends WriterBasedOutputWriter> TcpOutputWriterBuilder<T> builder(@Nonnull InetSocketAddress server, @Nonnull T target) {
        return new TcpOutputWriterBuilder<T>(server, target);
    }

    private LifecycledPool<SocketPoolable> createPool() {
        Config config = new Config().setAllocator((Allocator)new SocketAllocator(this.server, this.socketTimeoutMillis, this.charset)).setExpiration((Expiration)new SocketExpiration()).setSize(this.poolSize);
        return new BlazePool(config);
    }

    public WriterPoolOutputWriter<T> build() {
        LifecycledPool<SocketPoolable> pool = this.createPool();
        return new WriterPoolOutputWriter<T>(this.target, pool, new Timeout(1L, TimeUnit.SECONDS));
    }

    public TcpOutputWriterBuilder<T> setCharset(@Nonnull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
        return this;
    }

    public TcpOutputWriterBuilder<T> setSocketTimeoutMillis(int socketTimeoutMillis) {
        this.socketTimeoutMillis = socketTimeoutMillis;
        return this;
    }

    public TcpOutputWriterBuilder<T> setPoolSize(int poolSize) {
        this.poolSize = poolSize;
        return this;
    }
}

