/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support;

import com.google.common.base.Charsets;
import com.googlecode.jmxtrans.model.output.support.WriterBasedOutputWriter;
import com.googlecode.jmxtrans.model.output.support.WriterPoolOutputWriter;
import com.googlecode.jmxtrans.model.output.support.pool.DatagramChannelAllocator;
import com.googlecode.jmxtrans.model.output.support.pool.DatagramChannelExpiration;
import com.googlecode.jmxtrans.model.output.support.pool.DatagramChannelPoolable;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import stormpot.Allocator;
import stormpot.BlazePool;
import stormpot.Config;
import stormpot.Expiration;
import stormpot.LifecycledPool;
import stormpot.Timeout;

public class UdpOutputWriterBuilder<T extends WriterBasedOutputWriter> {
    @Nonnull
    private final InetSocketAddress server;
    @Nonnull
    private final T target;
    @Nonnull
    private Charset charset = Charsets.UTF_8;
    private int bufferSize = 1472;
    private int poolSize = 1;

    private UdpOutputWriterBuilder(@Nonnull InetSocketAddress server, @Nonnull T target) {
        this.server = server;
        this.target = target;
    }

    public static <T extends WriterBasedOutputWriter> UdpOutputWriterBuilder<T> builder(@Nonnull InetSocketAddress server, @Nonnull T target) {
        return new UdpOutputWriterBuilder<T>(server, target);
    }

    private LifecycledPool<DatagramChannelPoolable> createPool() {
        Config config = new Config().setAllocator((Allocator)new DatagramChannelAllocator(this.server, this.bufferSize, this.charset)).setExpiration((Expiration)new DatagramChannelExpiration()).setSize(this.poolSize);
        return new BlazePool(config);
    }

    public WriterPoolOutputWriter<T> build() {
        LifecycledPool<DatagramChannelPoolable> pool = this.createPool();
        return new WriterPoolOutputWriter<T>(this.target, pool, new Timeout(1L, TimeUnit.SECONDS));
    }

    public UdpOutputWriterBuilder<T> setCharset(@Nonnull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
        return this;
    }

    public UdpOutputWriterBuilder<T> setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public UdpOutputWriterBuilder<T> setPoolSize(int poolSize) {
        this.poolSize = poolSize;
        return this;
    }
}

