/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support.pool;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class ChannelWriter
extends Writer {
    @Nonnull
    private final Charset charset;
    @Nonnull
    private final ByteBuffer buffer;
    @Nonnull
    private final WritableByteChannel channel;

    public ChannelWriter(int bufferSize, @Nonnull Charset charset, @Nonnull WritableByteChannel channel) {
        this.charset = charset;
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            byte[] bytes = new String(cbuf, off, len).getBytes(this.charset);
            if (this.buffer.remaining() < bytes.length + 1) {
                this.flush();
            }
            this.buffer.put(bytes, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int sizeOfBuffer = this.buffer.position();
            if (sizeOfBuffer <= 0) {
                return;
            }
            this.buffer.flip();
            this.channel.write(this.buffer);
            this.buffer.limit(this.buffer.capacity());
            this.buffer.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Closer closer = Closer.create();
        try {
            closer.register((Closeable)this.channel);
            this.flush();
        }
        catch (Throwable t) {
            closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }
}

