/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support.pool;

import com.google.common.io.Closer;
import com.googlecode.jmxtrans.model.output.support.pool.ChannelWriter;
import com.googlecode.jmxtrans.model.output.support.pool.DatagramChannelPoolable;
import java.io.Closeable;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import stormpot.Allocator;
import stormpot.Slot;

public class DatagramChannelAllocator
implements Allocator<DatagramChannelPoolable> {
    @Nonnull
    private final InetSocketAddress server;
    @Nonnull
    private final int bufferSize;
    @Nonnull
    private final Charset charset;

    public DatagramChannelAllocator(@Nonnull InetSocketAddress server, @Nonnull int bufferSize, @Nonnull Charset charset) {
        this.server = server;
        this.bufferSize = bufferSize;
        this.charset = charset;
    }

    public DatagramChannelPoolable allocate(Slot slot) throws Exception {
        DatagramChannel channel = DatagramChannel.open();
        channel.connect(new InetSocketAddress(this.server.getHostName(), this.server.getPort()));
        ChannelWriter writer = new ChannelWriter(this.bufferSize, this.charset, channel);
        return new DatagramChannelPoolable(slot, writer, channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocate(DatagramChannelPoolable poolable) throws Exception {
        Closer closer = Closer.create();
        try {
            Writer writer = (Writer)closer.register((Closeable)poolable.getWriter());
            writer.flush();
        }
        catch (Throwable t) {
            closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }
}

