/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support.pool;

import com.google.common.io.Closer;
import com.googlecode.jmxtrans.model.output.support.pool.SocketPoolable;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import stormpot.Allocator;
import stormpot.Slot;

public class SocketAllocator
implements Allocator<SocketPoolable> {
    @Nonnull
    private final InetSocketAddress server;
    private final int socketTimeoutMillis;
    @Nonnull
    private final Charset charset;

    public SocketAllocator(@Nonnull InetSocketAddress server, int socketTimeoutMillis, @Nonnull Charset charset) {
        this.server = server;
        this.socketTimeoutMillis = socketTimeoutMillis;
        this.charset = charset;
    }

    public SocketPoolable allocate(Slot slot) throws Exception {
        InetSocketAddress serverAddress = new InetSocketAddress(this.server.getHostName(), this.server.getPort());
        Socket socket = new Socket();
        socket.setKeepAlive(false);
        socket.connect(serverAddress, this.socketTimeoutMillis);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), this.charset));
        return new SocketPoolable(slot, socket, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocate(SocketPoolable poolable) throws Exception {
        Closer closer = Closer.create();
        try {
            closer.register((Closeable)poolable.getSocket());
            closer.register((Closeable)poolable.getWriter());
        }
        catch (Throwable t) {
            closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }
}

