/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.output.StatsDWriter2;
import com.googlecode.jmxtrans.model.output.support.UdpOutputWriterBuilder;
import com.googlecode.jmxtrans.model.output.support.WriterPoolOutputWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import java.util.List;
import javax.annotation.Nonnull;

public class StatsDWriterFactory
implements OutputWriterFactory {
    @Nonnull
    private final ImmutableList<String> typeNames;
    @Nonnull
    private final String rootPrefix;
    private final boolean stringsValuesAsKey;
    @Nonnull
    private final String bucketType;
    @Nonnull
    private final Long stringValueDefaultCount;
    @Nonnull
    private final InetSocketAddress server;

    public StatsDWriterFactory(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="rootPrefix") String rootPrefix, @JsonProperty(value="bucketType") String bucketType, @JsonProperty(value="stringValuesAsKey") boolean stringsValuesAsKey, @JsonProperty(value="stringValueDefaultCount") Long stringValueDefaultCount, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port) {
        this.typeNames = (ImmutableList)MoreObjects.firstNonNull(typeNames, (Object)ImmutableList.of());
        this.rootPrefix = (String)MoreObjects.firstNonNull((Object)rootPrefix, (Object)"servers");
        this.stringsValuesAsKey = stringsValuesAsKey;
        this.bucketType = (String)MoreObjects.firstNonNull((Object)bucketType, (Object)"c");
        this.stringValueDefaultCount = (Long)MoreObjects.firstNonNull((Object)stringValueDefaultCount, (Object)1L);
        this.server = new InetSocketAddress((String)Preconditions.checkNotNull((Object)host, (Object)"Host cannot be null."), (int)((Integer)Preconditions.checkNotNull((Object)port, (Object)"Port cannot be null.")));
    }

    public WriterPoolOutputWriter<StatsDWriter2> create() {
        return UdpOutputWriterBuilder.builder(this.server, new StatsDWriter2((List<String>)this.typeNames, this.rootPrefix, this.bucketType, this.stringsValuesAsKey, this.stringValueDefaultCount)).setCharset(Charsets.UTF_8).build();
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatsDWriterFactory)) {
            return false;
        }
        StatsDWriterFactory other = (StatsDWriterFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ImmutableList<String> this$typeNames = this.typeNames;
        ImmutableList<String> other$typeNames = other.typeNames;
        if (this$typeNames == null ? other$typeNames != null : !this$typeNames.equals(other$typeNames)) {
            return false;
        }
        String this$rootPrefix = this.rootPrefix;
        String other$rootPrefix = other.rootPrefix;
        if (this$rootPrefix == null ? other$rootPrefix != null : !this$rootPrefix.equals(other$rootPrefix)) {
            return false;
        }
        if (this.stringsValuesAsKey != other.stringsValuesAsKey) {
            return false;
        }
        String this$bucketType = this.bucketType;
        String other$bucketType = other.bucketType;
        if (this$bucketType == null ? other$bucketType != null : !this$bucketType.equals(other$bucketType)) {
            return false;
        }
        Long this$stringValueDefaultCount = this.stringValueDefaultCount;
        Long other$stringValueDefaultCount = other.stringValueDefaultCount;
        if (this$stringValueDefaultCount == null ? other$stringValueDefaultCount != null : !((Object)this$stringValueDefaultCount).equals(other$stringValueDefaultCount)) {
            return false;
        }
        InetSocketAddress this$server = this.server;
        InetSocketAddress other$server = other.server;
        return !(this$server == null ? other$server != null : !((Object)this$server).equals(other$server));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof StatsDWriterFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImmutableList<String> $typeNames = this.typeNames;
        result = result * 59 + ($typeNames == null ? 43 : $typeNames.hashCode());
        String $rootPrefix = this.rootPrefix;
        result = result * 59 + ($rootPrefix == null ? 43 : $rootPrefix.hashCode());
        result = result * 59 + (this.stringsValuesAsKey ? 79 : 97);
        String $bucketType = this.bucketType;
        result = result * 59 + ($bucketType == null ? 43 : $bucketType.hashCode());
        Long $stringValueDefaultCount = this.stringValueDefaultCount;
        result = result * 59 + ($stringValueDefaultCount == null ? 43 : ((Object)$stringValueDefaultCount).hashCode());
        InetSocketAddress $server = this.server;
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "StatsDWriterFactory(typeNames=" + this.typeNames + ", rootPrefix=" + this.rootPrefix + ", stringsValuesAsKey=" + this.stringsValuesAsKey + ", bucketType=" + this.bucketType + ", stringValueDefaultCount=" + this.stringValueDefaultCount + ", server=" + this.server + ")";
    }
}

