/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.output.TCollectorUDPWriter2;
import com.googlecode.jmxtrans.model.output.support.ResultTransformerOutputWriter;
import com.googlecode.jmxtrans.model.output.support.UdpOutputWriterBuilder;
import com.googlecode.jmxtrans.model.output.support.opentsdb.OpenTSDBMessageFormatter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class TCollectorUDPWriterFactory
implements OutputWriterFactory {
    @Nonnull
    private final boolean booleanAsNumber;
    @Nonnull
    private final InetSocketAddress server;
    @Nonnull
    private final OpenTSDBMessageFormatter messageFormatter;

    @JsonCreator
    public TCollectorUDPWriterFactory(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="tags") Map<String, String> tags, @JsonProperty(value="tagName") String tagName, @JsonProperty(value="mergeTypeNamesTags") Boolean mergeTypeNamesTags, @JsonProperty(value="metricNamingExpression") String metricNamingExpression, @JsonProperty(value="addHostnameTag") Boolean addHostnameTag) throws LifecycleException, UnknownHostException {
        this.booleanAsNumber = booleanAsNumber;
        this.server = new InetSocketAddress((String)MoreObjects.firstNonNull((Object)host, (Object)"localhost"), (int)((Integer)MoreObjects.firstNonNull((Object)port, (Object)3030)));
        ImmutableMap immutableTags = tags == null ? ImmutableMap.of() : ImmutableMap.copyOf(tags);
        this.messageFormatter = new OpenTSDBMessageFormatter(typeNames, (ImmutableMap<String, String>)immutableTags, tagName, metricNamingExpression, mergeTypeNamesTags, addHostnameTag != false ? InetAddress.getLocalHost().getHostName() : null);
    }

    public OutputWriter create() {
        return ResultTransformerOutputWriter.booleanToNumber((boolean)this.booleanAsNumber, UdpOutputWriterBuilder.builder(this.server, new TCollectorUDPWriter2(this.messageFormatter)).build());
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TCollectorUDPWriterFactory)) {
            return false;
        }
        TCollectorUDPWriterFactory other = (TCollectorUDPWriterFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.booleanAsNumber != other.booleanAsNumber) {
            return false;
        }
        InetSocketAddress this$server = this.server;
        InetSocketAddress other$server = other.server;
        if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
            return false;
        }
        OpenTSDBMessageFormatter this$messageFormatter = this.messageFormatter;
        OpenTSDBMessageFormatter other$messageFormatter = other.messageFormatter;
        return !(this$messageFormatter == null ? other$messageFormatter != null : !((Object)this$messageFormatter).equals(other$messageFormatter));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof TCollectorUDPWriterFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.booleanAsNumber ? 79 : 97);
        InetSocketAddress $server = this.server;
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        OpenTSDBMessageFormatter $messageFormatter = this.messageFormatter;
        result = result * 59 + ($messageFormatter == null ? 43 : ((Object)$messageFormatter).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "TCollectorUDPWriterFactory(booleanAsNumber=" + this.booleanAsNumber + ", server=" + this.server + ", messageFormatter=" + this.messageFormatter + ")";
    }
}

