/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support;

import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.OutputWriterAdapter;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.output.support.WriterBasedOutputWriter;
import com.googlecode.jmxtrans.model.output.support.pool.WriterPoolable;
import java.io.IOException;
import javax.annotation.Nonnull;
import stormpot.LifecycledPool;
import stormpot.Timeout;

public class WriterPoolOutputWriter<T extends WriterBasedOutputWriter>
extends OutputWriterAdapter {
    @Nonnull
    private final T target;
    @Nonnull
    private final LifecycledPool<? extends WriterPoolable> writerPool;
    @Nonnull
    private final Timeout poolClaimTimeout;

    public WriterPoolOutputWriter(@Nonnull T target, @Nonnull LifecycledPool<? extends WriterPoolable> writerPool, @Nonnull Timeout poolClaimTimeout) {
        this.target = target;
        this.writerPool = writerPool;
        this.poolClaimTimeout = poolClaimTimeout;
    }

    public void doWrite(Server server, Query query, Iterable<Result> results) throws Exception {
        try {
            WriterPoolable writerPoolable = (WriterPoolable)this.writerPool.claim(this.poolClaimTimeout);
            try {
                this.target.write(writerPoolable.getWriter(), server, query, results);
            }
            catch (IOException ioe) {
                writerPoolable.invalidate();
                throw ioe;
            }
            finally {
                writerPoolable.release();
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Could not get writer from pool, please check if the server is available");
        }
    }

    public void stop() throws LifecycleException {
        this.writerPool.shutdown();
    }
}

