/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support.opentsdb;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.NamingStrategy;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.naming.ClassAttributeNamingStrategy;
import com.googlecode.jmxtrans.model.naming.JexlNamingStrategy;
import com.googlecode.jmxtrans.model.naming.typename.TypeNameValue;
import com.googlecode.jmxtrans.model.naming.typename.TypeNameValuesStringBuilder;
import com.googlecode.jmxtrans.util.NumberUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTSDBMessageFormatter {
    private static final Logger log = LoggerFactory.getLogger(OpenTSDBMessageFormatter.class);
    public static final String DEFAULT_TAG_NAME = "type";
    private final ImmutableList<String> typeNames;
    private final ImmutableMap<String, String> tags;
    private final String tagName;
    private final NamingStrategy metricNameStrategy;
    private final boolean mergeTypeNamesTags;
    private final String hostnameTag;

    public OpenTSDBMessageFormatter(@Nonnull ImmutableList<String> typeNames, @Nonnull ImmutableMap<String, String> tags) throws LifecycleException, UnknownHostException {
        this(typeNames, tags, DEFAULT_TAG_NAME, null, true, "localhost");
    }

    public OpenTSDBMessageFormatter(@Nonnull ImmutableList<String> typeNames, @Nonnull ImmutableMap<String, String> tags, @Nonnull String tagName, @Nullable String metricNamingExpression, boolean mergeTypeNamesTags, @Nullable String hostnameTag) throws UnknownHostException, LifecycleException {
        this.typeNames = typeNames;
        this.tags = tags;
        this.tagName = tagName;
        if (metricNamingExpression != null) {
            try {
                this.metricNameStrategy = new JexlNamingStrategy(metricNamingExpression);
            }
            catch (JexlException jexlExc) {
                throw new LifecycleException("failed to setup naming strategy", (Throwable)jexlExc);
            }
        } else {
            this.metricNameStrategy = new ClassAttributeNamingStrategy();
        }
        this.mergeTypeNamesTags = mergeTypeNamesTags;
        this.hostnameTag = hostnameTag;
    }

    void addTags(StringBuilder resultString) {
        if (this.hostnameTag != null) {
            this.addTag(resultString, "host", this.hostnameTag);
        }
        for (Map.Entry tagEntry : this.tags.entrySet()) {
            this.addTag(resultString, (String)tagEntry.getKey(), (String)tagEntry.getValue());
        }
    }

    void addTag(StringBuilder resultString, String tagName, String tagValue) {
        resultString.append(" ");
        resultString.append(this.sanitizeString(tagName));
        resultString.append("=");
        resultString.append(this.sanitizeString(tagValue));
    }

    private void formatResultString(StringBuilder resultString, String metricName, long epoch, Object value) {
        resultString.append(this.sanitizeString(metricName));
        resultString.append(" ");
        resultString.append(Long.toString(epoch));
        resultString.append(" ");
        resultString.append(this.sanitizeString(value.toString()));
    }

    private List<String> formatResult(Result result) {
        String attributeName;
        LinkedList<String> resultStrings = new LinkedList<String>();
        ImmutableMap values = result.getValues();
        if (values.containsKey(attributeName = result.getAttributeName()) && values.size() == 1) {
            this.processOneMetric(resultStrings, result, values.get(attributeName), null, null);
        } else {
            for (Map.Entry valueEntry : values.entrySet()) {
                this.processOneMetric(resultStrings, result, valueEntry.getValue(), this.tagName, (String)valueEntry.getKey());
            }
        }
        return resultStrings;
    }

    public Iterable<String> formatResults(Iterable<Result> results) {
        return FluentIterable.from(results).transformAndConcat((Function)new Function<Result, List<String>>(){

            public List<String> apply(Result input) {
                return OpenTSDBMessageFormatter.this.formatResult(input);
            }
        }).toList();
    }

    protected void processOneMetric(List<String> resultStrings, Result result, Object value, String addTagName, String addTagValue) {
        String metricName = this.metricNameStrategy.formatName(result);
        if (NumberUtils.isNumeric((Object)value)) {
            StringBuilder resultString = new StringBuilder();
            this.formatResultString(resultString, metricName, result.getEpoch() / 1000L, value);
            this.addTags(resultString);
            if (addTagName != null) {
                this.addTag(resultString, addTagName, addTagValue);
            }
            if (!this.typeNames.isEmpty()) {
                this.addTypeNamesTags(resultString, result);
            }
            resultStrings.add(resultString.toString());
        } else {
            log.debug("Skipping non-numeric value for metric {}; value={}", (Object)metricName, value);
        }
    }

    protected void addTypeNamesTags(StringBuilder resultString, Result result) {
        if (this.mergeTypeNamesTags) {
            String typeNameValues = TypeNameValuesStringBuilder.getDefaultBuilder().build(this.typeNames, result.getTypeName());
            this.addTag(resultString, StringUtils.join(this.typeNames, (String)""), typeNameValues);
        } else {
            Map typeNameMap = TypeNameValue.extractMap((String)result.getTypeName());
            for (String oneTypeName : this.typeNames) {
                String value = (String)typeNameMap.get(oneTypeName);
                if (value == null) {
                    value = "";
                }
                this.addTag(resultString, oneTypeName, value);
            }
        }
    }

    protected String sanitizeString(String unSanitized) {
        return unSanitized.replaceAll("[\"']", "").replaceAll("[^-_./a-zA-Z0-9]", "_");
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenTSDBMessageFormatter)) {
            return false;
        }
        OpenTSDBMessageFormatter other = (OpenTSDBMessageFormatter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ImmutableList<String> this$typeNames = this.typeNames;
        ImmutableList<String> other$typeNames = other.typeNames;
        if (this$typeNames == null ? other$typeNames != null : !this$typeNames.equals(other$typeNames)) {
            return false;
        }
        ImmutableMap<String, String> this$tags = this.tags;
        ImmutableMap<String, String> other$tags = other.tags;
        if (this$tags == null ? other$tags != null : !this$tags.equals(other$tags)) {
            return false;
        }
        String this$tagName = this.tagName;
        String other$tagName = other.tagName;
        if (this$tagName == null ? other$tagName != null : !this$tagName.equals(other$tagName)) {
            return false;
        }
        NamingStrategy this$metricNameStrategy = this.metricNameStrategy;
        NamingStrategy other$metricNameStrategy = other.metricNameStrategy;
        if (this$metricNameStrategy == null ? other$metricNameStrategy != null : !this$metricNameStrategy.equals(other$metricNameStrategy)) {
            return false;
        }
        if (this.mergeTypeNamesTags != other.mergeTypeNamesTags) {
            return false;
        }
        String this$hostnameTag = this.hostnameTag;
        String other$hostnameTag = other.hostnameTag;
        return !(this$hostnameTag == null ? other$hostnameTag != null : !this$hostnameTag.equals(other$hostnameTag));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof OpenTSDBMessageFormatter;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImmutableList<String> $typeNames = this.typeNames;
        result = result * 59 + ($typeNames == null ? 43 : $typeNames.hashCode());
        ImmutableMap<String, String> $tags = this.tags;
        result = result * 59 + ($tags == null ? 43 : $tags.hashCode());
        String $tagName = this.tagName;
        result = result * 59 + ($tagName == null ? 43 : $tagName.hashCode());
        NamingStrategy $metricNameStrategy = this.metricNameStrategy;
        result = result * 59 + ($metricNameStrategy == null ? 43 : $metricNameStrategy.hashCode());
        result = result * 59 + (this.mergeTypeNamesTags ? 79 : 97);
        String $hostnameTag = this.hostnameTag;
        result = result * 59 + ($hostnameTag == null ? 43 : $hostnameTag.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "OpenTSDBMessageFormatter(typeNames=" + this.typeNames + ", tags=" + this.tags + ", tagName=" + this.tagName + ", metricNameStrategy=" + this.metricNameStrategy + ", mergeTypeNamesTags=" + this.mergeTypeNamesTags + ", hostnameTag=" + this.hostnameTag + ")";
    }
}

