/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support.pool;

import com.googlecode.jmxtrans.model.output.support.pool.FlushStrategy;
import com.googlecode.jmxtrans.util.Clock;
import java.io.Flushable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class TimeBasedFlush
implements FlushStrategy {
    @Nonnull
    private long lastFlush;
    @Nonnull
    private final Clock clock;
    @Nonnull
    private final long flushPeriodMillisecond;

    public TimeBasedFlush(@Nonnull Clock clock, long flushPeriod, @Nonnull TimeUnit unit) {
        this.clock = clock;
        this.lastFlush = clock.currentTimeMillis();
        this.flushPeriodMillisecond = TimeUnit.MILLISECONDS.convert(flushPeriod, unit);
    }

    @Override
    public void flush(@Nonnull Flushable flushable) throws IOException {
        if (this.shouldFlush()) {
            flushable.flush();
        }
    }

    private synchronized boolean shouldFlush() {
        if (this.lastFlush + this.flushPeriodMillisecond < this.clock.currentTimeMillis()) {
            this.lastFlush = this.clock.currentTimeMillis();
            return true;
        }
        return false;
    }
}

