/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support.pool;

import com.googlecode.jmxtrans.model.output.support.pool.FlushStrategy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stormpot.Poolable;
import stormpot.Slot;

public class WriterPoolable
implements Poolable {
    private static final Logger logger = LoggerFactory.getLogger(WriterPoolable.class);
    @Nonnull
    private final Slot slot;
    @Nonnull
    private final Writer writer;
    @Nonnull
    private final FlushStrategy flushStrategy;

    public WriterPoolable(@Nonnull Slot slot, @Nonnull Writer writer, @Nonnull FlushStrategy flushStrategy) {
        this.slot = slot;
        this.writer = writer;
        this.flushStrategy = flushStrategy;
    }

    public void release() {
        try {
            this.flushStrategy.flush(this.writer);
            this.slot.release((Poolable)this);
        }
        catch (IOException ioe) {
            logger.error("Could not flush writer", (Throwable)ioe);
            this.invalidate();
        }
    }

    public void invalidate() {
        this.slot.expire((Poolable)this);
    }

    @Nonnull
    @SuppressFBWarnings(justification="generated code")
    public Writer getWriter() {
        return this.writer;
    }
}

