/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.output.OpenTSDBGenericWriter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCollectorUDPWriter
extends OpenTSDBGenericWriter {
    private static final Logger log = LoggerFactory.getLogger(TCollectorUDPWriter.class);
    protected SocketAddress address;
    protected DatagramSocket dgSocket;

    @JsonCreator
    public TCollectorUDPWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="tags") Map<String, String> tags, @JsonProperty(value="tagName") String tagName, @JsonProperty(value="mergeTypeNamesTags") Boolean mergeTypeNamesTags, @JsonProperty(value="metricNamingExpression") String metricNamingExpression, @JsonProperty(value="addHostnameTag") Boolean addHostnameTag, @JsonProperty(value="settings") Map<String, Object> settings) throws LifecycleException, UnknownHostException {
        super(typeNames, booleanAsNumber, debugEnabled, host, port, tags, tagName, mergeTypeNamesTags, metricNamingExpression, addHostnameTag, settings);
        log.warn("TCollectorUDPWriter is deprecated. Please use TCollectorUDPWriterFactory instead.");
    }

    @Override
    protected boolean getAddHostnameTagDefault() {
        return false;
    }

    @Override
    public void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        this.startOutput();
        for (String resultString : this.messageFormatter.formatResults((Iterable<Result>)results)) {
            log.debug("TCollectorUDP Message: {}", (Object)resultString);
            this.sendOutput(resultString);
        }
        this.finishOutput();
    }

    @Override
    public void prepareSender() throws LifecycleException {
        if (this.host == null || this.port == null) {
            throw new LifecycleException("Host and port for " + ((Object)((Object)this)).getClass().getSimpleName() + " output can't be null");
        }
        try {
            this.dgSocket = new DatagramSocket();
            this.address = new InetSocketAddress(this.host, (int)this.port);
        }
        catch (SocketException sockExc) {
            log.error("Failed to create a datagram socket", (Throwable)sockExc);
            throw new LifecycleException((Throwable)sockExc);
        }
    }

    @Override
    protected void sendOutput(String metricLine) throws IOException {
        byte[] data = metricLine.getBytes("UTF-8");
        DatagramPacket packet = new DatagramPacket(data, 0, data.length, this.address);
        this.dgSocket.send(packet);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final ImmutableList.Builder<String> typeNames = ImmutableList.builder();
        private boolean booleanAsNumber;
        private Boolean debugEnabled;
        private String host;
        private Integer port;
        private final ImmutableMap.Builder<String, String> tags = ImmutableMap.builder();
        private String tagName;
        private Boolean mergeTypeNamesTags;
        private String metricNamingExpression;
        private Boolean addHostnameTag;

        private Builder() {
        }

        public Builder addTypeNames(List<String> typeNames) {
            this.typeNames.addAll(typeNames);
            return this;
        }

        public Builder addTypeName(String typeName) {
            this.typeNames.add((Object)typeName);
            return this;
        }

        public Builder setBooleanAsNumber(boolean booleanAsNumber) {
            this.booleanAsNumber = booleanAsNumber;
            return this;
        }

        public Builder setDebugEnabled(boolean debugEnabled) {
            this.debugEnabled = debugEnabled;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder addTag(String key, String value) {
            this.tags.put((Object)key, (Object)value);
            return this;
        }

        public Builder addTags(Map<String, String> tags) {
            this.tags.putAll(tags);
            return this;
        }

        public Builder setTagName(String tagName) {
            this.tagName = tagName;
            return this;
        }

        public Builder setMergeTypeNamesTags(Boolean mergeTypeNamesTags) {
            this.mergeTypeNamesTags = mergeTypeNamesTags;
            return this;
        }

        public Builder setMetricNamingExpression(String metricNamingExpression) {
            this.metricNamingExpression = metricNamingExpression;
            return this;
        }

        public Builder setAddHostnameTag(Boolean addHostnameTag) {
            this.addHostnameTag = addHostnameTag;
            return this;
        }

        public TCollectorUDPWriter build() throws LifecycleException, UnknownHostException {
            return new TCollectorUDPWriter((ImmutableList<String>)this.typeNames.build(), this.booleanAsNumber, this.debugEnabled, this.host, this.port, (Map<String, String>)this.tags.build(), this.tagName, this.mergeTypeNamesTags, this.metricNamingExpression, this.addHostnameTag, null);
        }
    }
}

