/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWriter
extends BaseOutputWriter {
    private static final String PROPERTY_BASEPATH = "filepath";
    private static final String PROPERTY_LINE_FORMAT = "lineFormat";
    private static final String DEFAULT_LINE_FORMAT = "%s=%s";
    private static final Logger log = LoggerFactory.getLogger(FileWriter.class);
    private File outputFile;
    private File outputTempFile;
    private String lineFormat;

    public FileWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="filepath") String filepath, @JsonProperty(value="lineFormat") String lineFormat, @JsonProperty(value="settings") Map<String, Object> settings) throws IOException {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.outputFile = new File(filepath);
        Path outputFilePath = this.outputFile.toPath();
        this.outputTempFile = new File(outputFilePath.getParent() + File.separator + "." + outputFilePath.getFileName());
        this.lineFormat = lineFormat == null ? DEFAULT_LINE_FORMAT : lineFormat;
        FileWriter.touch(this.outputFile);
        FileWriter.touch(this.outputTempFile);
    }

    private static void touch(File file) throws IOException {
        new FileOutputStream(file, true).close();
        assert (file.setLastModified(System.currentTimeMillis()));
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
    }

    protected void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        try (PrintWriter outputTempPrintWriter = new PrintWriter(this.outputTempFile, "UTF-8");){
            ImmutableList typeNames = this.getTypeNames();
            for (Result result : results) {
                log.debug(result.toString());
                for (Map.Entry values : result.getValues().entrySet()) {
                    outputTempPrintWriter.printf(this.lineFormat + System.lineSeparator(), KeyUtils.getKeyString((Query)query, (Result)result, (Map.Entry)values, (List)typeNames), values.getValue());
                }
            }
        }
        Files.move(this.outputTempFile.toPath(), this.outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "FileWriter(outputFile=" + this.outputFile + ", outputTempFile=" + this.outputTempFile + ", lineFormat=" + this.lineFormat + ")";
    }
}

