/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonFactory;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.output.LibratoWriter2;
import com.googlecode.jmxtrans.model.output.support.HttpOutputWriter;
import com.googlecode.jmxtrans.model.output.support.HttpUrlConnectionConfigurer;
import com.googlecode.jmxtrans.model.output.support.ResultTransformerOutputWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LibratoWriterFactory
implements OutputWriterFactory {
    private final boolean booleanAsNumber;
    @Nonnull
    private final ImmutableList<String> typeNames;
    @Nonnull
    private final URL url;
    @Nullable
    private final Proxy proxy;
    @Nonnull
    private final int readTimeoutInMillis;
    @Nullable
    private final String authorization;

    public LibratoWriterFactory(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="url") URL url, @JsonProperty(value="libratoApiTimeoutInMillis") Integer readTimeoutInMillis, @JsonProperty(value="username") String username, @JsonProperty(value="token") String token, @JsonProperty(value="proxyHost") String proxyHost, @JsonProperty(value="proxyPort") Integer proxyPort) {
        this.booleanAsNumber = booleanAsNumber;
        this.typeNames = (ImmutableList)MoreObjects.firstNonNull(typeNames, (Object)ImmutableList.of());
        this.url = (URL)Preconditions.checkNotNull((Object)url);
        this.readTimeoutInMillis = (Integer)MoreObjects.firstNonNull((Object)readTimeoutInMillis, (Object)1000);
        this.authorization = "Basic" + Base64Variants.getDefaultVariant().encode(((String)Preconditions.checkNotNull((Object)username) + ":" + (String)Preconditions.checkNotNull((Object)token)).getBytes(Charsets.US_ASCII));
        this.proxy = this.initProxy(proxyHost, proxyPort);
    }

    private Proxy initProxy(String proxyHost, Integer proxyPort) {
        if (proxyHost == null) {
            return null;
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, (int)((Integer)Preconditions.checkNotNull((Object)proxyPort, (Object)"Proxy port needs to be specified."))));
    }

    public ResultTransformerOutputWriter<HttpOutputWriter<LibratoWriter2>> create() {
        return ResultTransformerOutputWriter.booleanToNumber((boolean)this.booleanAsNumber, new HttpOutputWriter<LibratoWriter2>(new LibratoWriter2(new JsonFactory(), this.typeNames), this.url, this.proxy, new HttpUrlConnectionConfigurer("POST", this.readTimeoutInMillis, this.authorization, "application/json; charset=utf-8"), Charsets.UTF_8));
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LibratoWriterFactory)) {
            return false;
        }
        LibratoWriterFactory other = (LibratoWriterFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.booleanAsNumber != other.booleanAsNumber) {
            return false;
        }
        ImmutableList<String> this$typeNames = this.typeNames;
        ImmutableList<String> other$typeNames = other.typeNames;
        if (this$typeNames == null ? other$typeNames != null : !this$typeNames.equals(other$typeNames)) {
            return false;
        }
        URL this$url = this.url;
        URL other$url = other.url;
        if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
            return false;
        }
        Proxy this$proxy = this.proxy;
        Proxy other$proxy = other.proxy;
        if (this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy)) {
            return false;
        }
        if (this.readTimeoutInMillis != other.readTimeoutInMillis) {
            return false;
        }
        String this$authorization = this.authorization;
        String other$authorization = other.authorization;
        return !(this$authorization == null ? other$authorization != null : !this$authorization.equals(other$authorization));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof LibratoWriterFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.booleanAsNumber ? 79 : 97);
        ImmutableList<String> $typeNames = this.typeNames;
        result = result * 59 + ($typeNames == null ? 43 : $typeNames.hashCode());
        URL $url = this.url;
        result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
        Proxy $proxy = this.proxy;
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        result = result * 59 + this.readTimeoutInMillis;
        String $authorization = this.authorization;
        result = result * 59 + ($authorization == null ? 43 : $authorization.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "LibratoWriterFactory(booleanAsNumber=" + this.booleanAsNumber + ", typeNames=" + this.typeNames + ", url=" + this.url + ", proxy=" + this.proxy + ", readTimeoutInMillis=" + this.readTimeoutInMillis + ", authorization=" + this.authorization + ")";
    }
}

