/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.output.GraphiteWriter2;
import com.googlecode.jmxtrans.model.output.support.WriterBasedOutputWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Nonnull;

public class SensuWriter2
implements WriterBasedOutputWriter {
    @Nonnull
    private final GraphiteWriter2 graphiteWriter;
    @Nonnull
    private final JsonFactory jsonFactory;

    public SensuWriter2(@Nonnull GraphiteWriter2 graphiteWriter, @Nonnull JsonFactory jsonFactory) {
        this.graphiteWriter = graphiteWriter;
        this.jsonFactory = jsonFactory;
    }

    @Override
    public void write(@Nonnull Writer writer, @Nonnull Server server, @Nonnull Query query, @Nonnull Iterable<Result> results) throws IOException {
        try (JsonGenerator g = this.jsonFactory.createGenerator(writer);
             StringWriter temporaryWriter = new StringWriter();){
            g.useDefaultPrettyPrinter();
            g.writeStartObject();
            g.writeStringField("name", "jmxtrans");
            g.writeStringField("type", "metric");
            g.writeStringField("handler", "graphite");
            this.graphiteWriter.write(temporaryWriter, server, query, results);
            g.writeStringField("output", temporaryWriter.toString());
            g.writeEndObject();
            g.flush();
        }
    }
}

