/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.output.GraphiteWriter2;
import com.googlecode.jmxtrans.model.output.SensuWriter2;
import com.googlecode.jmxtrans.model.output.support.ResultTransformerOutputWriter;
import com.googlecode.jmxtrans.model.output.support.TcpOutputWriterBuilder;
import com.googlecode.jmxtrans.model.output.support.WriterPoolOutputWriter;
import com.googlecode.jmxtrans.model.output.support.pool.FlushStrategy;
import com.googlecode.jmxtrans.model.output.support.pool.FlushStrategyUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SensuWriterFactory
implements OutputWriterFactory {
    private final boolean booleanAsNumber;
    @Nonnull
    private final InetSocketAddress server;
    @Nonnull
    private final ImmutableList<String> typeNames;
    @Nullable
    private final String rootPrefix;
    @Nonnull
    private final FlushStrategy flushStrategy;
    private final int poolSize;

    public SensuWriterFactory(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="rootPrefix") String rootPrefix, @JsonProperty(value="flushStrategy") String flushStrategy, @JsonProperty(value="flushDelayInSeconds") Integer flushDelayInSeconds, @JsonProperty(value="poolSize") Integer poolSize) {
        this.rootPrefix = rootPrefix;
        this.typeNames = (ImmutableList)MoreObjects.firstNonNull(typeNames, (Object)ImmutableList.of());
        this.booleanAsNumber = booleanAsNumber;
        this.server = new InetSocketAddress((String)MoreObjects.firstNonNull((Object)host, (Object)"localhost"), (int)((Integer)MoreObjects.firstNonNull((Object)port, (Object)3030)));
        this.flushStrategy = FlushStrategyUtils.createFlushStrategy(flushStrategy, flushDelayInSeconds);
        this.poolSize = (Integer)MoreObjects.firstNonNull((Object)poolSize, (Object)1);
    }

    public ResultTransformerOutputWriter<WriterPoolOutputWriter<SensuWriter2>> create() {
        return ResultTransformerOutputWriter.booleanToNumber((boolean)this.booleanAsNumber, TcpOutputWriterBuilder.builder(this.server, new SensuWriter2(new GraphiteWriter2(this.typeNames, this.rootPrefix), new JsonFactory())).setFlushStrategy(this.flushStrategy).setPoolSize(this.poolSize).build());
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SensuWriterFactory)) {
            return false;
        }
        SensuWriterFactory other = (SensuWriterFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.booleanAsNumber != other.booleanAsNumber) {
            return false;
        }
        InetSocketAddress this$server = this.server;
        InetSocketAddress other$server = other.server;
        if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
            return false;
        }
        ImmutableList<String> this$typeNames = this.typeNames;
        ImmutableList<String> other$typeNames = other.typeNames;
        if (this$typeNames == null ? other$typeNames != null : !this$typeNames.equals(other$typeNames)) {
            return false;
        }
        String this$rootPrefix = this.rootPrefix;
        String other$rootPrefix = other.rootPrefix;
        if (this$rootPrefix == null ? other$rootPrefix != null : !this$rootPrefix.equals(other$rootPrefix)) {
            return false;
        }
        FlushStrategy this$flushStrategy = this.flushStrategy;
        FlushStrategy other$flushStrategy = other.flushStrategy;
        if (this$flushStrategy == null ? other$flushStrategy != null : !this$flushStrategy.equals(other$flushStrategy)) {
            return false;
        }
        return this.poolSize == other.poolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof SensuWriterFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.booleanAsNumber ? 79 : 97);
        InetSocketAddress $server = this.server;
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        ImmutableList<String> $typeNames = this.typeNames;
        result = result * 59 + ($typeNames == null ? 43 : $typeNames.hashCode());
        String $rootPrefix = this.rootPrefix;
        result = result * 59 + ($rootPrefix == null ? 43 : $rootPrefix.hashCode());
        FlushStrategy $flushStrategy = this.flushStrategy;
        result = result * 59 + ($flushStrategy == null ? 43 : $flushStrategy.hashCode());
        result = result * 59 + this.poolSize;
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "SensuWriterFactory(booleanAsNumber=" + this.booleanAsNumber + ", server=" + this.server + ", typeNames=" + this.typeNames + ", rootPrefix=" + this.rootPrefix + ", flushStrategy=" + this.flushStrategy + ", poolSize=" + this.poolSize + ")";
    }
}

