/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.util.NumberUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensuWriter
extends BaseOutputWriter {
    private static final Logger logger = LoggerFactory.getLogger(SensuWriter.class);
    public static final String SETTING_HANDLER = "handler";
    public static final String DEFAULT_SENSU_HOST = "localhost";
    public static final String DEFAULT_SENSU_HANDLER = "graphite";
    private final JsonFactory jsonFactory = new JsonFactory();
    private final String host;
    private final String handler;

    @JsonCreator
    public SensuWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="host") String host, @JsonProperty(value="handler") String handler, @JsonProperty(value="settings") Map<String, Object> settings) {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        logger.warn("SensuWriter is deprecated. Please use SensuWriterFactory instead.");
        this.host = (String)this.firstNonNull(host, (String)this.getSettings().get("host"), DEFAULT_SENSU_HOST);
        this.handler = (String)this.firstNonNull(handler, (String)this.getSettings().get(SETTING_HANDLER), DEFAULT_SENSU_HANDLER);
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
        logger.info("Start Sensu writer connected to '{}' with handler {}", (Object)this.host, (Object)this.handler);
    }

    public void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        logger.debug("Export to '{}', metrics {}", (Object)this.host, (Object)query);
        this.writeToSensu(server, query, (List<Result>)results);
    }

    private void serialize(Server server, Query query, List<Result> results, OutputStream outputStream) throws IOException {
        JsonGenerator g = this.jsonFactory.createGenerator(outputStream, JsonEncoding.UTF8);
        g.useDefaultPrettyPrinter();
        g.writeStartObject();
        g.writeStringField("name", "jmxtrans");
        g.writeStringField("type", "metric");
        g.writeStringField(SETTING_HANDLER, this.handler);
        StringBuilder jsonoutput = new StringBuilder();
        ImmutableList typeNames = this.getTypeNames();
        for (Result result : results) {
            for (Map.Entry values : result.getValues().entrySet()) {
                if (!NumberUtils.isNumeric(values.getValue())) continue;
                Object value = values.getValue();
                jsonoutput.append(KeyUtils.getKeyString((Server)server, (Query)query, (Result)result, (Map.Entry)values, (List)typeNames, null)).append(" ").append(value).append(" ").append(TimeUnit.SECONDS.convert(result.getEpoch(), TimeUnit.MILLISECONDS)).append(System.getProperty("line.separator"));
            }
        }
        g.writeStringField("output", jsonoutput.toString());
        g.writeEndObject();
        g.flush();
        g.close();
    }

    private void writeToSensu(Server server, Query query, List<Result> results) {
        try (Socket socketConnection = new Socket(this.host, 3030);){
            this.serialize(server, query, results, socketConnection.getOutputStream());
        }
        catch (Exception e) {
            logger.warn("Failure to send result to Sensu server '{}'", (Object)this.host, (Object)e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public String getHandler() {
        return this.handler;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SensuWriter)) {
            return false;
        }
        SensuWriter other = (SensuWriter)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$handler = this.getHandler();
        String other$handler = other.getHandler();
        return !(this$handler == null ? other$handler != null : !this$handler.equals(other$handler));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof SensuWriter;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $handler = this.getHandler();
        result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "SensuWriter(jsonFactory=" + this.jsonFactory + ", host=" + this.getHost() + ", handler=" + this.getHandler() + ")";
    }
}

