/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.naming.StringUtils;
import com.googlecode.jmxtrans.model.output.support.WriterBasedOutputWriter;
import com.googlecode.jmxtrans.util.NumberUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class LibratoWriter2
implements WriterBasedOutputWriter {
    @Nonnull
    private final JsonFactory jsonFactory;
    @Nonnull
    private final ImmutableList<String> typeNames;

    public LibratoWriter2(@Nonnull JsonFactory jsonFactory, @Nonnull ImmutableList<String> typeNames) {
        this.jsonFactory = jsonFactory;
        this.typeNames = typeNames;
    }

    @Override
    public void write(@Nonnull Writer writer, @Nonnull Server server, @Nonnull Query query, @Nonnull Iterable<Result> results) throws IOException {
        try (Closer closer = Closer.create();){
            JsonGenerator g = (JsonGenerator)closer.register((Closeable)this.jsonFactory.createGenerator(writer));
            g.writeStartObject();
            g.writeArrayFieldStart("counters");
            g.writeEndArray();
            String source = this.getSource(server);
            g.writeArrayFieldStart("gauges");
            for (Result result : results) {
                ImmutableMap resultValues = result.getValues();
                for (Map.Entry values : resultValues.entrySet()) {
                    if (!NumberUtils.isNumeric(values.getValue())) continue;
                    g.writeStartObject();
                    g.writeStringField("name", KeyUtils.getKeyString((Query)query, (Result)result, values, this.typeNames));
                    if (source != null && !source.isEmpty()) {
                        g.writeStringField("source", source);
                    }
                    g.writeNumberField("measure_time", TimeUnit.SECONDS.convert(result.getEpoch(), TimeUnit.MILLISECONDS));
                    Object value = values.getValue();
                    if (value instanceof Integer) {
                        g.writeNumberField("value", ((Integer)value).intValue());
                    } else if (value instanceof Long) {
                        g.writeNumberField("value", ((Long)value).longValue());
                    } else if (value instanceof Float) {
                        g.writeNumberField("value", ((Float)value).floatValue());
                    } else if (value instanceof Double) {
                        g.writeNumberField("value", ((Double)value).doubleValue());
                    }
                    g.writeEndObject();
                }
            }
            g.writeEndArray();
            g.writeEndObject();
            g.flush();
        }
    }

    private String getSource(Server server) {
        if (server.getAlias() != null) {
            return server.getAlias();
        }
        return StringUtils.cleanupStr((String)server.getHost());
    }
}

