/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.output.GraphiteWriter2;
import com.googlecode.jmxtrans.model.output.support.ResultTransformerOutputWriter;
import com.googlecode.jmxtrans.model.output.support.TcpOutputWriterBuilder;
import com.googlecode.jmxtrans.model.output.support.UdpOutputWriterBuilder;
import com.googlecode.jmxtrans.model.output.support.WriterPoolOutputWriter;
import com.googlecode.jmxtrans.model.output.support.pool.FlushStrategy;
import com.googlecode.jmxtrans.model.output.support.pool.FlushStrategyUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class GraphiteWriterFactory
implements OutputWriterFactory {
    private static final String DEFAULT_ROOT_PREFIX = "servers";
    private static final String DEFAULT_PROTOCOL = "tcp";
    @Nonnull
    private final String rootPrefix;
    @Nonnull
    private final InetSocketAddress graphiteServer;
    @Nonnull
    private final ImmutableList<String> typeNames;
    private final boolean booleanAsNumber;
    @Nonnull
    private final FlushStrategy flushStrategy;
    private final int poolSize;
    private final int socketTimeoutMs;
    private final Integer poolClaimTimeoutSeconds;
    private final String protocol;

    @JsonCreator
    public GraphiteWriterFactory(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="rootPrefix") String rootPrefix, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="flushStrategy") String flushStrategy, @JsonProperty(value="flushDelayInSeconds") Integer flushDelayInSeconds, @JsonProperty(value="poolSize") Integer poolSize, @JsonProperty(value="socketTimeoutMs") Integer socketTimeoutMs, @JsonProperty(value="poolClaimTimeoutSeconds") Integer poolClaimTimeoutSeconds, @JsonProperty(value="protocol") String protocol) {
        this.typeNames = typeNames;
        this.booleanAsNumber = booleanAsNumber;
        this.rootPrefix = (String)MoreObjects.firstNonNull((Object)rootPrefix, (Object)DEFAULT_ROOT_PREFIX);
        this.graphiteServer = new InetSocketAddress((String)Preconditions.checkNotNull((Object)host, (Object)"Host cannot be null."), (int)((Integer)Preconditions.checkNotNull((Object)port, (Object)"Port cannot be null.")));
        this.flushStrategy = FlushStrategyUtils.createFlushStrategy(flushStrategy, flushDelayInSeconds);
        this.poolSize = (Integer)MoreObjects.firstNonNull((Object)poolSize, (Object)1);
        this.socketTimeoutMs = (Integer)MoreObjects.firstNonNull((Object)socketTimeoutMs, (Object)200);
        this.poolClaimTimeoutSeconds = (Integer)MoreObjects.firstNonNull((Object)poolClaimTimeoutSeconds, (Object)1);
        this.protocol = (String)MoreObjects.firstNonNull((Object)protocol, (Object)DEFAULT_PROTOCOL);
    }

    public ResultTransformerOutputWriter<WriterPoolOutputWriter<GraphiteWriter2>> create() {
        WriterPoolOutputWriter<GraphiteWriter2> writerPoolOutputWriter = "udp".equals(this.protocol) ? UdpOutputWriterBuilder.builder(this.graphiteServer, new GraphiteWriter2(this.typeNames, this.rootPrefix)).setCharset(Charsets.UTF_8).setFlushStrategy(this.flushStrategy).setPoolSize(this.poolSize).setPoolClaimTimeoutSeconds(this.poolClaimTimeoutSeconds).build() : TcpOutputWriterBuilder.builder(this.graphiteServer, new GraphiteWriter2(this.typeNames, this.rootPrefix)).setCharset(Charsets.UTF_8).setFlushStrategy(this.flushStrategy).setPoolSize(this.poolSize).setSocketTimeoutMillis(this.socketTimeoutMs).setPoolClaimTimeoutSeconds(this.poolClaimTimeoutSeconds).build();
        return ResultTransformerOutputWriter.booleanToNumber((boolean)this.booleanAsNumber, writerPoolOutputWriter);
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphiteWriterFactory)) {
            return false;
        }
        GraphiteWriterFactory other = (GraphiteWriterFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$rootPrefix = this.rootPrefix;
        String other$rootPrefix = other.rootPrefix;
        if (this$rootPrefix == null ? other$rootPrefix != null : !this$rootPrefix.equals(other$rootPrefix)) {
            return false;
        }
        InetSocketAddress this$graphiteServer = this.graphiteServer;
        InetSocketAddress other$graphiteServer = other.graphiteServer;
        if (this$graphiteServer == null ? other$graphiteServer != null : !((Object)this$graphiteServer).equals(other$graphiteServer)) {
            return false;
        }
        ImmutableList<String> this$typeNames = this.typeNames;
        ImmutableList<String> other$typeNames = other.typeNames;
        if (this$typeNames == null ? other$typeNames != null : !this$typeNames.equals(other$typeNames)) {
            return false;
        }
        if (this.booleanAsNumber != other.booleanAsNumber) {
            return false;
        }
        FlushStrategy this$flushStrategy = this.flushStrategy;
        FlushStrategy other$flushStrategy = other.flushStrategy;
        if (this$flushStrategy == null ? other$flushStrategy != null : !this$flushStrategy.equals(other$flushStrategy)) {
            return false;
        }
        if (this.poolSize != other.poolSize) {
            return false;
        }
        if (this.socketTimeoutMs != other.socketTimeoutMs) {
            return false;
        }
        Integer this$poolClaimTimeoutSeconds = this.poolClaimTimeoutSeconds;
        Integer other$poolClaimTimeoutSeconds = other.poolClaimTimeoutSeconds;
        if (this$poolClaimTimeoutSeconds == null ? other$poolClaimTimeoutSeconds != null : !((Object)this$poolClaimTimeoutSeconds).equals(other$poolClaimTimeoutSeconds)) {
            return false;
        }
        String this$protocol = this.protocol;
        String other$protocol = other.protocol;
        return !(this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof GraphiteWriterFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rootPrefix = this.rootPrefix;
        result = result * 59 + ($rootPrefix == null ? 43 : $rootPrefix.hashCode());
        InetSocketAddress $graphiteServer = this.graphiteServer;
        result = result * 59 + ($graphiteServer == null ? 43 : ((Object)$graphiteServer).hashCode());
        ImmutableList<String> $typeNames = this.typeNames;
        result = result * 59 + ($typeNames == null ? 43 : $typeNames.hashCode());
        result = result * 59 + (this.booleanAsNumber ? 79 : 97);
        FlushStrategy $flushStrategy = this.flushStrategy;
        result = result * 59 + ($flushStrategy == null ? 43 : $flushStrategy.hashCode());
        result = result * 59 + this.poolSize;
        result = result * 59 + this.socketTimeoutMs;
        Integer $poolClaimTimeoutSeconds = this.poolClaimTimeoutSeconds;
        result = result * 59 + ($poolClaimTimeoutSeconds == null ? 43 : ((Object)$poolClaimTimeoutSeconds).hashCode());
        String $protocol = this.protocol;
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "GraphiteWriterFactory(rootPrefix=" + this.rootPrefix + ", graphiteServer=" + this.graphiteServer + ", typeNames=" + this.typeNames + ", booleanAsNumber=" + this.booleanAsNumber + ", flushStrategy=" + this.flushStrategy + ", poolSize=" + this.poolSize + ", socketTimeoutMs=" + this.socketTimeoutMs + ", poolClaimTimeoutSeconds=" + this.poolClaimTimeoutSeconds + ", protocol=" + this.protocol + ")";
    }
}

