/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.naming.typename.TypeNameValuesStringBuilder;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.model.output.Settings;
import com.googlecode.jmxtrans.util.NumberUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackdriverWriter
extends BaseOutputWriter {
    private static final Logger logger = LoggerFactory.getLogger(StackdriverWriter.class);
    public static final int STACKDRIVER_PROTOCOL_VERSION = 1;
    public static final int DEFAULT_STACKDRIVER_API_TIMEOUT_IN_MILLIS = 1000;
    public static final String DEFAULT_STACKDRIVER_API_URL = "https://custom-gateway.stackdriver.com/v1/custom";
    public static final String SETTING_STACKDRIVER_API_URL = "url";
    public static final String SETTING_PROXY_PORT = "proxyPort";
    public static final String SETTING_PROXY_HOST = "proxyHost";
    public static final String SETTING_STACKDRIVER_API_KEY = "token";
    public static final String SETTING_SOURCE_INSTANCE = "source";
    public static final String SETTING_DETECT_INSTANCE = "detectInstance";
    public static final String SETTING_STACKDRIVER_API_TIMEOUT_IN_MILLIS = "stackdriverApiTimeoutInMillis";
    public static final String SETTING_PREFIX = "prefix";
    private final String instanceId;
    private final String source;
    private final String detectInstance;
    private final String prefix;
    private final URL gatewayUrl;
    private final Proxy proxy;
    private final String proxyHost;
    private final Integer proxyPort;
    private final String apiKey;
    private int timeoutInMillis = 1000;
    private JsonFactory jsonFactory = new JsonFactory();

    @JsonCreator
    public StackdriverWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="gatewayUrl") String gatewayUrl, @JsonProperty(value="apiKey") String apiKey, @JsonProperty(value="proxyHost") String proxyHost, @JsonProperty(value="proxyPort") Integer proxyPort, @JsonProperty(value="prefix") String prefix, @JsonProperty(value="timeoutInMillis") Integer timeoutInMillis, @JsonProperty(value="source") String source, @JsonProperty(value="detectInstance") String detectInstance, @JsonProperty(value="settings") Map<String, Object> settings) throws MalformedURLException {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.gatewayUrl = new URL((String)this.firstNonNull(gatewayUrl, (String)this.getSettings().get(SETTING_STACKDRIVER_API_URL), DEFAULT_STACKDRIVER_API_URL));
        this.apiKey = (String)MoreObjects.firstNonNull((Object)apiKey, (Object)((String)this.getSettings().get(SETTING_STACKDRIVER_API_KEY)));
        if (proxyHost == null) {
            proxyHost = (String)this.getSettings().get(SETTING_PROXY_HOST);
        }
        if (proxyPort == null) {
            proxyPort = (Integer)this.getSettings().get(SETTING_PROXY_PORT);
        }
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxy = !Strings.isNullOrEmpty((String)this.proxyHost) ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, (int)this.proxyPort)) : null;
        this.prefix = (String)this.firstNonNull(prefix, (String)this.getSettings().get(SETTING_PREFIX), "");
        if (!Strings.isNullOrEmpty((String)this.prefix) && !StringUtils.isAlphanumeric((String)this.prefix)) {
            throw new IllegalArgumentException("Prefix setting must be alphanumeric only [A-Za-z0-9]");
        }
        logger.info("Setting prefix to " + this.prefix);
        this.timeoutInMillis = (Integer)this.firstNonNull(timeoutInMillis, Settings.getIntegerSetting((Map)this.getSettings(), (String)SETTING_STACKDRIVER_API_TIMEOUT_IN_MILLIS, null), 1000);
        if (source == null) {
            source = (String)this.getSettings().get(SETTING_SOURCE_INSTANCE);
        }
        this.source = source;
        if (detectInstance == null) {
            detectInstance = (String)this.getSettings().get(SETTING_DETECT_INSTANCE);
        }
        this.detectInstance = detectInstance;
        this.instanceId = this.computeInstanceId(this.source, this.detectInstance);
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
        logger.info("Starting Stackdriver writer connected to '{}', proxy {} ...", (Object)this.gatewayUrl, (Object)this.proxy);
    }

    private String computeInstanceId(String source, String detectInstance) {
        String result;
        if (!Strings.isNullOrEmpty((String)source)) {
            result = source;
            logger.info("Using instance ID {} from setting {}", (Object)result, (Object)SETTING_SOURCE_INSTANCE);
        } else if ("AWS".equalsIgnoreCase(detectInstance)) {
            logger.info("Detect instance set to AWS, trying to determine AWS instance ID");
            result = this.getLocalInstanceId("AWS", "http://169.254.169.254/latest/meta-data/instance-id", null);
            if (result == null) {
                logger.info("Unable to detect AWS instance ID for this machine, sending metrics without an instance ID");
            }
        } else if ("GCE".equalsIgnoreCase(detectInstance)) {
            logger.info("Detect instance set to GCE, trying to determine GCE instance ID");
            result = this.getLocalInstanceId("GCE", "http://metadata/computeMetadata/v1/instance/id", (Map<String, String>)ImmutableMap.of((Object)"X-Google-Metadata-Request", (Object)"True"));
            if (result == null) {
                logger.info("Unable to detect GCE instance ID for this machine, sending metrics without an instance ID");
            }
        } else {
            result = null;
            logger.info("No source instance ID passed, and not set to detect, sending metrics without an instance ID");
        }
        logger.info("Detected instance ID as {}", (Object)result);
        return result;
    }

    public void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        String gatewayMessage = this.getGatewayMessage((List<Result>)results);
        if (gatewayMessage != null) {
            logger.info(gatewayMessage);
            this.doSend(gatewayMessage);
        }
    }

    private String getGatewayMessage(List<Result> results) throws IOException {
        int valueCount = 0;
        StringWriter writer = new StringWriter();
        JsonGenerator g = this.jsonFactory.createGenerator((Writer)writer);
        g.writeStartObject();
        g.writeNumberField("timestamp", System.currentTimeMillis() / 1000L);
        g.writeNumberField("proto_version", 1);
        g.writeArrayFieldStart("data");
        ImmutableList typeNames = this.getTypeNames();
        for (Result metric : results) {
            ImmutableMap values = metric.getValues();
            if (values == null) continue;
            for (Map.Entry entry : values.entrySet()) {
                if (!NumberUtils.isNumeric(entry.getValue())) continue;
                StringBuilder nameBuilder = new StringBuilder();
                if (this.prefix != null) {
                    nameBuilder.append(this.prefix);
                    nameBuilder.append(".");
                }
                if (!metric.getKeyAlias().isEmpty()) {
                    nameBuilder.append(metric.getKeyAlias());
                } else {
                    nameBuilder.append(metric.getClassName());
                }
                String typeName = com.googlecode.jmxtrans.model.naming.StringUtils.cleanupStr((String)TypeNameValuesStringBuilder.getDefaultBuilder().build((List)typeNames, metric.getTypeName()));
                if (typeName != null && typeName.length() > 0) {
                    nameBuilder.append(".");
                    nameBuilder.append(typeName);
                }
                nameBuilder.append(".");
                nameBuilder.append(metric.getAttributeName());
                if (!((String)entry.getKey()).equals(metric.getAttributeName())) {
                    nameBuilder.append(".");
                    nameBuilder.append((String)entry.getKey());
                }
                if (entry.getValue() instanceof Float && ((Float)entry.getValue()).isNaN()) {
                    logger.info("Metric value for " + nameBuilder.toString() + " is NaN, skipping");
                    continue;
                }
                if (entry.getValue() instanceof Double && ((Double)entry.getValue()).isNaN()) {
                    logger.info("Metric value for " + nameBuilder.toString() + " is NaN, skipping");
                    continue;
                }
                ++valueCount;
                g.writeStartObject();
                g.writeStringField("name", nameBuilder.toString());
                g.writeNumberField("value", Double.valueOf(entry.getValue().toString()).doubleValue());
                if (this.instanceId != null && !this.instanceId.isEmpty()) {
                    g.writeStringField("instance", this.instanceId);
                }
                g.writeNumberField("collected_at", metric.getEpoch() / 1000L);
                g.writeEndObject();
            }
        }
        g.writeEndArray();
        g.writeEndObject();
        g.flush();
        g.close();
        if (valueCount > 0) {
            return ((Object)writer).toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend(String gatewayMessage) {
        URLConnection urlConnection = null;
        try {
            urlConnection = this.proxy == null ? (HttpURLConnection)this.gatewayUrl.openConnection() : (HttpURLConnection)this.gatewayUrl.openConnection(this.proxy);
            ((HttpURLConnection)urlConnection).setRequestMethod("POST");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            urlConnection.setReadTimeout(this.timeoutInMillis);
            urlConnection.setRequestProperty("content-type", "application/json; charset=utf-8");
            urlConnection.setRequestProperty("x-stackdriver-apikey", this.apiKey);
            urlConnection.getOutputStream().write(gatewayMessage.getBytes(Charsets.ISO_8859_1));
            int responseCode = ((HttpURLConnection)urlConnection).getResponseCode();
            if (responseCode != 200 && responseCode != 201) {
                logger.warn("Failed to send results to Stackdriver server: responseCode=" + responseCode + " message=" + ((HttpURLConnection)urlConnection).getResponseMessage());
            }
        }
        catch (Exception e) {
            logger.warn("Failure to send result to Stackdriver server", (Throwable)e);
        }
        finally {
            if (urlConnection != null) {
                try {
                    InputStream in = urlConnection.getInputStream();
                    in.close();
                    InputStream err = ((HttpURLConnection)urlConnection).getErrorStream();
                    if (err != null) {
                        err.close();
                    }
                    ((HttpURLConnection)urlConnection).disconnect();
                }
                catch (IOException e) {
                    logger.warn("Error flushing http connection for one result, continuing");
                    logger.debug("Stack trace for the http connection, usually a network timeout", (Throwable)e);
                }
            }
        }
    }

    private String getLocalInstanceId(String cloudProvider, String metadataEndpoint, Map<String, String> headers) {
        String detectedInstanceId = null;
        try {
            String inputLine;
            URL metadataUrl = new URL(metadataEndpoint);
            URLConnection metadataConnection = metadataUrl.openConnection();
            if (headers != null) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    metadataConnection.setRequestProperty(header.getKey(), header.getValue());
                }
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(metadataConnection.getInputStream(), "UTF-8"));
            while ((inputLine = in.readLine()) != null) {
                detectedInstanceId = inputLine;
            }
            in.close();
        }
        catch (Exception e) {
            logger.warn("unable to determine " + cloudProvider + " instance ID", (Throwable)e);
        }
        return detectedInstanceId;
    }

    public String getGatewayUrl() {
        return this.gatewayUrl.toString();
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public int getTimeoutInMillis() {
        return this.timeoutInMillis;
    }

    public String getSource() {
        return this.source;
    }

    public String getDetectInstance() {
        return this.detectInstance;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StackdriverWriter)) {
            return false;
        }
        StackdriverWriter other = (StackdriverWriter)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$instanceId = this.instanceId;
        String other$instanceId = other.instanceId;
        if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$detectInstance = this.getDetectInstance();
        String other$detectInstance = other.getDetectInstance();
        if (this$detectInstance == null ? other$detectInstance != null : !this$detectInstance.equals(other$detectInstance)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$gatewayUrl = this.getGatewayUrl();
        String other$gatewayUrl = other.getGatewayUrl();
        if (this$gatewayUrl == null ? other$gatewayUrl != null : !this$gatewayUrl.equals(other$gatewayUrl)) {
            return false;
        }
        Proxy this$proxy = this.proxy;
        Proxy other$proxy = other.proxy;
        if (this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy)) {
            return false;
        }
        String this$proxyHost = this.getProxyHost();
        String other$proxyHost = other.getProxyHost();
        if (this$proxyHost == null ? other$proxyHost != null : !this$proxyHost.equals(other$proxyHost)) {
            return false;
        }
        Integer this$proxyPort = this.getProxyPort();
        Integer other$proxyPort = other.getProxyPort();
        if (this$proxyPort == null ? other$proxyPort != null : !((Object)this$proxyPort).equals(other$proxyPort)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        return this.getTimeoutInMillis() == other.getTimeoutInMillis();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof StackdriverWriter;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $instanceId = this.instanceId;
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $detectInstance = this.getDetectInstance();
        result = result * 59 + ($detectInstance == null ? 43 : $detectInstance.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $gatewayUrl = this.getGatewayUrl();
        result = result * 59 + ($gatewayUrl == null ? 43 : $gatewayUrl.hashCode());
        Proxy $proxy = this.proxy;
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        String $proxyHost = this.getProxyHost();
        result = result * 59 + ($proxyHost == null ? 43 : $proxyHost.hashCode());
        Integer $proxyPort = this.getProxyPort();
        result = result * 59 + ($proxyPort == null ? 43 : ((Object)$proxyPort).hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        result = result * 59 + this.getTimeoutInMillis();
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "StackdriverWriter(instanceId=" + this.instanceId + ", source=" + this.getSource() + ", detectInstance=" + this.getDetectInstance() + ", prefix=" + this.getPrefix() + ", gatewayUrl=" + this.getGatewayUrl() + ", proxy=" + this.proxy + ", proxyHost=" + this.getProxyHost() + ", proxyPort=" + this.getProxyPort() + ", apiKey=" + this.getApiKey() + ", timeoutInMillis=" + this.getTimeoutInMillis() + ", jsonFactory=" + this.jsonFactory + ")";
    }
}

