/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.model.output.Settings;
import com.googlecode.jmxtrans.model.output.support.opentsdb.OpenTSDBMessageFormatter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OpenTSDBGenericWriter
extends BaseOutputWriter {
    public static final boolean DEFAULT_MERGE_TYPE_NAMES_TAGS = true;
    private static final Logger log = LoggerFactory.getLogger(OpenTSDBGenericWriter.class);
    protected final String host;
    protected final Integer port;
    protected final OpenTSDBMessageFormatter messageFormatter;

    @JsonCreator
    public OpenTSDBGenericWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="tags") Map<String, String> tags, @JsonProperty(value="tagName") String tagName, @JsonProperty(value="mergeTypeNamesTags") Boolean mergeTypeNamesTags, @JsonProperty(value="metricNamingExpression") String metricNamingExpression, @JsonProperty(value="addHostnameTag") Boolean addHostnameTag, @JsonProperty(value="settings") Map<String, Object> settings) throws LifecycleException {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.host = (String)MoreObjects.firstNonNull((Object)host, (Object)((String)this.getSettings().get("host")));
        this.port = (Integer)MoreObjects.firstNonNull((Object)port, (Object)Settings.getIntegerSetting((Map)this.getSettings(), (String)"port", null));
        if (metricNamingExpression == null) {
            metricNamingExpression = Settings.getStringSetting((Map)this.getSettings(), (String)"metricNamingExpression", null);
        }
        ImmutableList nonNullTypeNames = ImmutableList.copyOf((Collection)((Collection)MoreObjects.firstNonNull(typeNames, Collections.emptyList())));
        this.messageFormatter = new OpenTSDBMessageFormatter((ImmutableList<String>)nonNullTypeNames, (ImmutableMap<String, String>)ImmutableMap.copyOf((Map)((Map)this.firstNonNull(tags, (Map)this.getSettings().get("tags"), ImmutableMap.of()))), (String)this.firstNonNull(tagName, (String)this.getSettings().get("tagName"), "type"), metricNamingExpression, (Boolean)MoreObjects.firstNonNull((Object)mergeTypeNamesTags, (Object)Settings.getBooleanSetting((Map)this.getSettings(), (String)"mergeTypeNamesTags", (Boolean)true)), addHostnameTag);
    }

    protected void prepareSender() throws LifecycleException {
    }

    protected void shutdownSender() throws LifecycleException {
    }

    protected void startOutput() throws IOException {
    }

    protected abstract boolean getAddHostnameTagDefault();

    protected abstract void sendOutput(String var1) throws IOException;

    protected void finishOutput() throws IOException {
    }

    public void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        this.startOutput();
        for (String formattedResult : this.messageFormatter.formatResults((Iterable<Result>)results, server)) {
            log.debug("Sending result: {}", (Object)formattedResult);
            this.sendOutput(formattedResult);
        }
        this.finishOutput();
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
    }

    public void start() throws LifecycleException {
        this.prepareSender();
    }

    public void close() throws LifecycleException {
        this.shutdownSender();
    }
}

