/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.output.support.WriterBasedOutputWriter;
import com.googlecode.jmxtrans.model.results.CPrecisionValueTransformer;
import com.googlecode.jmxtrans.model.results.ValueTransformer;
import com.googlecode.jmxtrans.util.NumberUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsDWriter2
implements WriterBasedOutputWriter {
    @Nonnull
    private static final Logger log = LoggerFactory.getLogger(StatsDWriter2.class);
    @Nonnull
    private final List<String> typeNames;
    @Nonnull
    private final String rootPrefix;
    private final boolean stringsValuesAsKey;
    @Nonnull
    private final String bucketType;
    @Nonnull
    private final String stringValueDefaultCount;
    @Nonnull
    private final String replacementForInvalidChar;
    @Nonnull
    private final ValueTransformer valueTransformer = new CPrecisionValueTransformer();
    private static final Pattern STATSD_INVALID = Pattern.compile("[:|]");

    public StatsDWriter2(@Nonnull List<String> typeNames, @Nonnull String rootPrefix, @Nonnull String bucketType, boolean stringsValuesAsKey, @Nonnull Long stringValueDefaultCount, @Nonnull String replacementForInvalidChar) {
        this.typeNames = typeNames;
        this.rootPrefix = rootPrefix;
        this.stringsValuesAsKey = stringsValuesAsKey;
        this.bucketType = bucketType;
        this.stringValueDefaultCount = stringValueDefaultCount.toString();
        this.replacementForInvalidChar = replacementForInvalidChar;
    }

    @Override
    public void write(@Nonnull Writer writer, @Nonnull Server server, @Nonnull Query query, @Nonnull Iterable<Result> results) throws IOException {
        for (Result result : results) {
            for (Map.Entry values : result.getValues().entrySet()) {
                if (this.isNotValidValue(values.getValue())) {
                    log.debug("Skipping message key[{}] with value: {}.", values.getKey(), values.getValue());
                    continue;
                }
                String line = KeyUtils.getKeyString((Server)server, (Query)query, (Result)result, (Map.Entry)values, this.typeNames, (String)this.rootPrefix);
                line = STATSD_INVALID.matcher(line).replaceAll(this.replacementForInvalidChar);
                line = line + this.computeActualValue(values.getValue()) + "|" + this.bucketType + "\n";
                writer.write(line);
            }
        }
    }

    private boolean isNotValidValue(Object value) {
        return !NumberUtils.isNumeric((Object)value) && !this.stringsValuesAsKey;
    }

    private String computeActualValue(Object value) {
        Object transformedValue = this.valueTransformer.apply(value);
        if (NumberUtils.isNumeric((Object)transformedValue)) {
            return ":" + transformedValue.toString();
        }
        if (transformedValue == null) {
            return ":";
        }
        return "." + transformedValue.toString() + ":" + this.stringValueDefaultCount;
    }
}

