/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.output.support.WriterBasedOutputWriter;
import com.googlecode.jmxtrans.util.NumberUtils;
import com.googlecode.jmxtrans.util.OnlyOnceLogger;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GraphiteWriter2
implements WriterBasedOutputWriter {
    private static final Logger log = LoggerFactory.getLogger(GraphiteWriter2.class);
    private final OnlyOnceLogger onlyOnceLogger = new OnlyOnceLogger(log);
    @Nonnull
    private final ImmutableList<String> typeNames;
    @Nullable
    private final String rootPrefix;

    public GraphiteWriter2(@Nonnull ImmutableList<String> typeNames, @Nullable String rootPrefix) {
        this.typeNames = typeNames;
        this.rootPrefix = rootPrefix;
    }

    @Override
    public void write(@Nonnull Writer writer, @Nonnull Server server, @Nonnull Query query, @Nonnull Iterable<Result> results) throws IOException {
        for (Result result : results) {
            log.debug("Query result: {}", (Object)result);
            Object value = result.getValue();
            if (NumberUtils.isValidNumber((Object)value)) {
                String line = KeyUtils.getKeyString((Server)server, (Query)query, (Result)result, this.typeNames, (String)this.rootPrefix).replaceAll("[()]", "_") + " " + value.toString() + " " + TimeUnit.SECONDS.convert(result.getEpoch(), TimeUnit.MILLISECONDS) + "\n";
                log.debug("Graphite Message: {}", (Object)line);
                writer.write(line);
                continue;
            }
            this.onlyOnceLogger.infoOnce("Unable to submit non-numeric value to Graphite: [{}] from result [{}]", new Object[]{value, result});
        }
    }
}

