/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.output.support.WriterBasedOutputWriter;
import com.googlecode.jmxtrans.model.output.support.opentsdb.OpenTSDBMessageFormatter;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OpenTSDBWriter2
implements WriterBasedOutputWriter {
    private static final Logger logger = LoggerFactory.getLogger(OpenTSDBWriter2.class);
    private final OpenTSDBMessageFormatter messageFormatter;

    public OpenTSDBWriter2(OpenTSDBMessageFormatter messageFormatter) {
        this.messageFormatter = messageFormatter;
    }

    @Override
    public void write(@Nonnull Writer writer, @Nonnull Server server, @Nonnull Query query, @Nonnull Iterable<Result> results) throws IOException {
        for (String resultString : this.messageFormatter.formatResults(results, server)) {
            logger.trace(resultString);
            writer.write("put " + resultString + "\n");
        }
    }
}

