/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.ResultAttribute;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.output.StatsDMetricType;
import com.googlecode.jmxtrans.model.output.support.WriterBasedOutputWriter;
import com.googlecode.jmxtrans.model.results.CPrecisionValueTransformer;
import com.googlecode.jmxtrans.model.results.ValueTransformer;
import com.googlecode.jmxtrans.util.NumberUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsDTelegrafWriter
implements WriterBasedOutputWriter {
    private static final Logger log = LoggerFactory.getLogger(StatsDTelegrafWriter.class);
    @Nonnull
    private final ValueTransformer valueTransformer = new CPrecisionValueTransformer();
    @Nonnull
    private final ImmutableList<String> bucketTypes;
    @Nonnull
    private final ImmutableMap<String, String> tags;
    @Nonnull
    private final ImmutableSet<ResultAttribute> resultAttributesToWriteAsTags;

    public StatsDTelegrafWriter(String[] bucketTypes, ImmutableMap<String, String> tags, ImmutableSet<ResultAttribute> resultAttributesToWriteAsTags) {
        this.bucketTypes = ImmutableList.copyOf((Object[])bucketTypes);
        this.tags = tags;
        this.resultAttributesToWriteAsTags = resultAttributesToWriteAsTags;
    }

    @Override
    public void write(@Nonnull Writer writer, @Nonnull Server server, @Nonnull Query query, @Nonnull Iterable<Result> results) throws IOException {
        int resultIndex = -1;
        for (Result result : results) {
            String bucketType = this.getBucketType(++resultIndex);
            String attributeName = result.getAttributeName();
            ArrayList<String> resultTagList = new ArrayList<String>();
            resultTagList.add(",jmxport=" + server.getPort());
            resultTagList.add("attribute=" + attributeName);
            if (this.isNotValidValue(result.getValue())) {
                log.debug("Skipping message key[{}] with value: {}.", (Object)result.getAttributeName(), result.getValue());
                continue;
            }
            ArrayList<String> tagList = new ArrayList<String>(resultTagList);
            if (!result.getValuePath().isEmpty()) {
                tagList.add("resultKey=" + KeyUtils.getValuePathString((Result)result));
            }
            for (Map.Entry e : this.tags.entrySet()) {
                tagList.add(e.getKey() + "=" + e.getValue());
            }
            Number actualValue = this.computeActualValue(result.getValue());
            StringBuilder sb = new StringBuilder(result.getKeyAlias()).append(StringUtils.join(tagList, (String)",")).append(":").append(actualValue).append("|").append(bucketType).append("\n");
            String output = sb.toString();
            if (actualValue.floatValue() < 0.0f && !StatsDMetricType.GAUGE.getKey().equals(bucketType)) {
                log.debug("Negative values are only supported for gauges, not sending: {}.", (Object)output);
                continue;
            }
            log.debug(output);
            writer.write(output);
        }
    }

    private String getBucketType(int resultIndex) {
        if (this.bucketTypes.size() > resultIndex) {
            return (String)this.bucketTypes.get(resultIndex);
        }
        return (String)Iterables.getLast(this.bucketTypes);
    }

    private boolean isNotValidValue(Object value) {
        return !NumberUtils.isNumeric((Object)value);
    }

    private Number computeActualValue(Object value) {
        Object transformedValue = this.valueTransformer.apply(value);
        if (NumberUtils.isNumeric((Object)transformedValue)) {
            return transformedValue instanceof Number ? (Number)((Number)transformedValue) : (Number)Float.valueOf(transformedValue.toString());
        }
        throw new IllegalArgumentException("Only numeric values are supported, enable debug log level for more details.");
    }
}

