/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.output.TCollectorUDPWriter2;
import com.googlecode.jmxtrans.model.output.support.ResultTransformerOutputWriter;
import com.googlecode.jmxtrans.model.output.support.UdpOutputWriterBuilder;
import com.googlecode.jmxtrans.model.output.support.opentsdb.OpenTSDBMessageFormatter;
import com.googlecode.jmxtrans.model.output.support.pool.FlushStrategy;
import com.googlecode.jmxtrans.model.output.support.pool.FlushStrategyUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class TCollectorUDPWriterFactory
implements OutputWriterFactory {
    @Nonnull
    private final boolean booleanAsNumber;
    @Nonnull
    private final InetSocketAddress server;
    @Nonnull
    private final OpenTSDBMessageFormatter messageFormatter;
    @Nonnull
    private final FlushStrategy flushStrategy;
    private final int poolSize;

    @JsonCreator
    public TCollectorUDPWriterFactory(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="tags") Map<String, String> tags, @JsonProperty(value="tagName") String tagName, @JsonProperty(value="mergeTypeNamesTags") Boolean mergeTypeNamesTags, @JsonProperty(value="metricNamingExpression") String metricNamingExpression, @JsonProperty(value="addHostnameTag") Boolean addHostnameTag, @JsonProperty(value="flushStrategy") String flushStrategy, @JsonProperty(value="flushDelayInSeconds") Integer flushDelayInSeconds, @JsonProperty(value="poolSize") Integer poolSize) throws LifecycleException, UnknownHostException {
        this.booleanAsNumber = booleanAsNumber;
        this.server = new InetSocketAddress((String)MoreObjects.firstNonNull((Object)host, (Object)"localhost"), (int)((Integer)MoreObjects.firstNonNull((Object)port, (Object)3030)));
        ImmutableMap immutableTags = tags == null ? ImmutableMap.of() : ImmutableMap.copyOf(tags);
        this.messageFormatter = new OpenTSDBMessageFormatter(typeNames, (ImmutableMap<String, String>)immutableTags, tagName, metricNamingExpression, mergeTypeNamesTags, addHostnameTag);
        this.flushStrategy = FlushStrategyUtils.createFlushStrategy(flushStrategy, flushDelayInSeconds);
        this.poolSize = (Integer)MoreObjects.firstNonNull((Object)poolSize, (Object)1);
    }

    public OutputWriter create() {
        return ResultTransformerOutputWriter.booleanToNumber((boolean)this.booleanAsNumber, UdpOutputWriterBuilder.builder(this.server, new TCollectorUDPWriter2(this.messageFormatter)).setFlushStrategy(this.flushStrategy).setPoolSize(this.poolSize).build());
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TCollectorUDPWriterFactory)) {
            return false;
        }
        TCollectorUDPWriterFactory other = (TCollectorUDPWriterFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.booleanAsNumber != other.booleanAsNumber) {
            return false;
        }
        InetSocketAddress this$server = this.server;
        InetSocketAddress other$server = other.server;
        if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
            return false;
        }
        OpenTSDBMessageFormatter this$messageFormatter = this.messageFormatter;
        OpenTSDBMessageFormatter other$messageFormatter = other.messageFormatter;
        if (this$messageFormatter == null ? other$messageFormatter != null : !((Object)this$messageFormatter).equals(other$messageFormatter)) {
            return false;
        }
        FlushStrategy this$flushStrategy = this.flushStrategy;
        FlushStrategy other$flushStrategy = other.flushStrategy;
        if (this$flushStrategy == null ? other$flushStrategy != null : !this$flushStrategy.equals(other$flushStrategy)) {
            return false;
        }
        return this.poolSize == other.poolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof TCollectorUDPWriterFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.booleanAsNumber ? 79 : 97);
        InetSocketAddress $server = this.server;
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        OpenTSDBMessageFormatter $messageFormatter = this.messageFormatter;
        result = result * 59 + ($messageFormatter == null ? 43 : ((Object)$messageFormatter).hashCode());
        FlushStrategy $flushStrategy = this.flushStrategy;
        result = result * 59 + ($flushStrategy == null ? 43 : $flushStrategy.hashCode());
        result = result * 59 + this.poolSize;
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "TCollectorUDPWriterFactory(booleanAsNumber=" + this.booleanAsNumber + ", server=" + this.server + ", messageFormatter=" + this.messageFormatter + ", flushStrategy=" + this.flushStrategy + ", poolSize=" + this.poolSize + ")";
    }
}

