/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.output.support.WriterBasedOutputWriter;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ZabbixWriter
implements WriterBasedOutputWriter {
    private static final Logger log = LoggerFactory.getLogger(ZabbixWriter.class);
    @Nonnull
    private final JsonFactory jsonFactory;
    @Nonnull
    private final ImmutableList<String> typeNames;

    public ZabbixWriter(@Nonnull JsonFactory jsonFactory, @Nonnull ImmutableList<String> typeNames) {
        this.jsonFactory = jsonFactory;
        this.typeNames = typeNames;
    }

    @Override
    public void write(@Nonnull Writer writer, @Nonnull Server server, @Nonnull Query query, @Nonnull Iterable<Result> results) throws IOException {
        try (JsonGenerator g = this.jsonFactory.createGenerator(writer);){
            g.useDefaultPrettyPrinter();
            g.writeStartObject();
            g.writeStringField("request", "sender data");
            g.writeArrayFieldStart("data");
            for (Result result : results) {
                log.debug("Query result: {}", (Object)result);
                String key = "jmxtrans." + KeyUtils.getKeyString((Query)query, (Result)result, this.typeNames);
                Object value = result.getValue();
                g.writeStartObject();
                g.writeStringField("host", server.getLabel());
                g.writeStringField("key", key);
                g.writeStringField("value", value.toString());
                g.writeNumberField("clock", result.getEpoch() / 1000L);
                g.writeEndObject();
            }
            g.writeEndArray();
            g.writeNumberField("clock", System.currentTimeMillis() / 1000L);
            g.writeEndObject();
            g.flush();
        }
    }
}

