/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.output.ZabbixWriter;
import com.googlecode.jmxtrans.model.output.support.ResultTransformerOutputWriter;
import com.googlecode.jmxtrans.model.output.support.TcpOutputWriterBuilder;
import com.googlecode.jmxtrans.model.output.support.WriterPoolOutputWriter;
import com.googlecode.jmxtrans.model.output.support.pool.FlushStrategy;
import com.googlecode.jmxtrans.model.output.support.pool.FlushStrategyUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ZabbixWriterFactory
implements OutputWriterFactory {
    @Nonnull
    private final InetSocketAddress zabbixServer;
    @Nonnull
    private final ImmutableList<String> typeNames;
    private final boolean booleanAsNumber;
    @Nonnull
    private final FlushStrategy flushStrategy;
    private final int poolSize;

    public ZabbixWriterFactory(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="flushStrategy") String flushStrategy, @JsonProperty(value="flushDelayInSeconds") Integer flushDelayInSeconds, @JsonProperty(value="poolSize") Integer poolSize) {
        this.typeNames = typeNames;
        this.booleanAsNumber = booleanAsNumber;
        this.zabbixServer = new InetSocketAddress((String)Preconditions.checkNotNull((Object)host, (Object)"Host cannot be null."), (int)((Integer)Preconditions.checkNotNull((Object)port, (Object)"Port cannot be null.")));
        this.flushStrategy = FlushStrategyUtils.createFlushStrategy(flushStrategy, flushDelayInSeconds);
        this.poolSize = (Integer)MoreObjects.firstNonNull((Object)poolSize, (Object)1);
    }

    public ResultTransformerOutputWriter<WriterPoolOutputWriter<ZabbixWriter>> create() {
        return ResultTransformerOutputWriter.booleanToNumber((boolean)this.booleanAsNumber, TcpOutputWriterBuilder.builder(this.zabbixServer, new ZabbixWriter(new JsonFactory(), this.typeNames)).setCharset(Charsets.UTF_8).setFlushStrategy(this.flushStrategy).setPoolSize(this.poolSize).build());
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZabbixWriterFactory)) {
            return false;
        }
        ZabbixWriterFactory other = (ZabbixWriterFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InetSocketAddress this$zabbixServer = this.zabbixServer;
        InetSocketAddress other$zabbixServer = other.zabbixServer;
        if (this$zabbixServer == null ? other$zabbixServer != null : !((Object)this$zabbixServer).equals(other$zabbixServer)) {
            return false;
        }
        ImmutableList<String> this$typeNames = this.typeNames;
        ImmutableList<String> other$typeNames = other.typeNames;
        if (this$typeNames == null ? other$typeNames != null : !this$typeNames.equals(other$typeNames)) {
            return false;
        }
        if (this.booleanAsNumber != other.booleanAsNumber) {
            return false;
        }
        FlushStrategy this$flushStrategy = this.flushStrategy;
        FlushStrategy other$flushStrategy = other.flushStrategy;
        if (this$flushStrategy == null ? other$flushStrategy != null : !this$flushStrategy.equals(other$flushStrategy)) {
            return false;
        }
        return this.poolSize == other.poolSize;
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof ZabbixWriterFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InetSocketAddress $zabbixServer = this.zabbixServer;
        result = result * 59 + ($zabbixServer == null ? 43 : ((Object)$zabbixServer).hashCode());
        ImmutableList<String> $typeNames = this.typeNames;
        result = result * 59 + ($typeNames == null ? 43 : $typeNames.hashCode());
        result = result * 59 + (this.booleanAsNumber ? 79 : 97);
        FlushStrategy $flushStrategy = this.flushStrategy;
        result = result * 59 + ($flushStrategy == null ? 43 : $flushStrategy.hashCode());
        result = result * 59 + this.poolSize;
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "ZabbixWriterFactory(zabbixServer=" + this.zabbixServer + ", typeNames=" + this.typeNames + ", booleanAsNumber=" + this.booleanAsNumber + ", flushStrategy=" + this.flushStrategy + ", poolSize=" + this.poolSize + ")";
    }
}

