/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support;

import com.google.common.annotations.VisibleForTesting;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.OutputWriterAdapter;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.output.support.WriterBasedOutputWriter;
import com.googlecode.jmxtrans.model.output.support.pool.WriterPoolable;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stormpot.LifecycledPool;
import stormpot.Timeout;

public class WriterPoolOutputWriter<T extends WriterBasedOutputWriter>
extends OutputWriterAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WriterPoolOutputWriter.class);
    @Nonnull
    private final T target;
    @Nonnull
    private final LifecycledPool<? extends WriterPoolable> writerPool;
    @Nonnull
    private final Timeout poolClaimTimeout;
    @Nullable
    private int socketTimeoutMs;

    public WriterPoolOutputWriter(@Nonnull T target, @Nonnull LifecycledPool<? extends WriterPoolable> writerPool, @Nonnull Timeout poolClaimTimeout) {
        this.target = target;
        this.writerPool = writerPool;
        this.poolClaimTimeout = poolClaimTimeout;
    }

    public WriterPoolOutputWriter(@Nonnull T target, @Nonnull LifecycledPool<? extends WriterPoolable> writerPool, @Nonnull Timeout poolClaimTimeout, @Nullable int socketTimeoutMs) {
        this.target = target;
        this.writerPool = writerPool;
        this.poolClaimTimeout = poolClaimTimeout;
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public void doWrite(Server server, Query query, Iterable<Result> results) throws Exception {
        WriterPoolable writerPoolable = this.claimWriter();
        try {
            this.target.write(writerPoolable.getWriter(), server, query, results);
        }
        catch (IOException ioe) {
            writerPoolable.invalidate();
            throw ioe;
        }
        finally {
            writerPoolable.release();
        }
    }

    public void close() throws LifecycleException {
        this.writerPool.shutdown();
    }

    private WriterPoolable claimWriter() {
        WriterPoolable result = null;
        try {
            result = (WriterPoolable)this.writerPool.claim(this.poolClaimTimeout);
        }
        catch (InterruptedException ex) {
            logger.error("Interrupted while attempting to claim writer from pool", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
        if (result == null) {
            throw new IllegalStateException("Could not get writer from pool, please check if the server is available");
        }
        return result;
    }

    @VisibleForTesting
    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    @VisibleForTesting
    Timeout getPoolClaimTimeout() {
        return this.poolClaimTimeout;
    }

    @VisibleForTesting
    public LifecycledPool<? extends WriterPoolable> getWriterPool() {
        return this.writerPool;
    }
}

