/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support.pool;

import com.googlecode.jmxtrans.model.output.support.pool.AlwaysFlush;
import com.googlecode.jmxtrans.model.output.support.pool.FlushStrategy;
import com.googlecode.jmxtrans.model.output.support.pool.NeverFlush;
import com.googlecode.jmxtrans.model.output.support.pool.TimeBasedFlush;
import com.googlecode.jmxtrans.util.Clock;
import com.googlecode.jmxtrans.util.SystemClock;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FlushStrategyUtils {
    private FlushStrategyUtils() {
    }

    @Nonnull
    public static FlushStrategy createFlushStrategy(@Nullable String strategy, @Nullable Integer flushDelayInSeconds) {
        if (strategy == null) {
            return new NeverFlush();
        }
        if (strategy.equals("never")) {
            return new NeverFlush();
        }
        if (strategy.equals("always")) {
            return new AlwaysFlush();
        }
        if (strategy.equals("timeBased")) {
            if (flushDelayInSeconds == null) {
                throw new IllegalArgumentException("flushDelayInSeconds cannot be null");
            }
            return new TimeBasedFlush((Clock)new SystemClock(), flushDelayInSeconds.intValue(), TimeUnit.SECONDS);
        }
        throw new IllegalArgumentException(String.format("Strategy %s is not valid, supported values are 'never', 'always' and 'timeBased'", strategy));
    }
}

