/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support.pool;

import com.googlecode.jmxtrans.model.output.support.pool.SocketPoolable;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stormpot.Expiration;
import stormpot.SlotInfo;

public class SocketExpiration
implements Expiration<SocketPoolable> {
    private static final Logger log = LoggerFactory.getLogger(SocketExpiration.class);

    public boolean hasExpired(SlotInfo<? extends SocketPoolable> info) throws Exception {
        Socket socket = ((SocketPoolable)info.getPoolable()).getSocket();
        try {
            return socket == null || !socket.isConnected() || !socket.isBound() || socket.isClosed() || socket.isInputShutdown() || socket.isOutputShutdown();
        }
        catch (Exception e) {
            log.warn("Socket {} is expired", (Object)socket, (Object)e);
            return true;
        }
    }
}

