/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.output.OpenTSDBGenericWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTSDBWriter
extends OpenTSDBGenericWriter {
    private static final Logger log = LoggerFactory.getLogger(OpenTSDBWriter.class);
    private GenericKeyedObjectPool<InetSocketAddress, Socket> pool;
    private final InetSocketAddress address;

    @JsonCreator
    public OpenTSDBWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="tags") Map<String, String> tags, @JsonProperty(value="tagName") String tagName, @JsonProperty(value="mergeTypeNamesTags") Boolean mergeTypeNamesTags, @JsonProperty(value="metricNamingExpression") String metricNamingExpression, @JsonProperty(value="addHostnameTag") Boolean addHostnameTag, @JsonProperty(value="settings") Map<String, Object> settings) throws LifecycleException, UnknownHostException {
        super(typeNames, booleanAsNumber, debugEnabled, host, port, tags, tagName, mergeTypeNamesTags, metricNamingExpression, addHostnameTag, settings);
        log.warn("OpenTSDBWriter is deprecated. Please use OpenTSDBWriterFactory instead.");
        this.address = new InetSocketAddress(host, (int)port);
    }

    @Override
    protected boolean getAddHostnameTagDefault() {
        return true;
    }

    @Override
    protected void sendOutput(String metricLine) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        Socket socket = null;
        PrintWriter writer = null;
        try {
            socket = (Socket)this.pool.borrowObject((Object)this.address);
            writer = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream(), Charsets.UTF_8), true);
            for (String formattedResult : this.messageFormatter.formatResults((Iterable<Result>)results, server)) {
                log.debug("OpenTSDB Message: {}", (Object)formattedResult);
                writer.write("put " + formattedResult + "\n");
            }
        }
        catch (ConnectException e) {
            log.error("Error while connecting to OpenTSDB", (Throwable)e);
        }
        finally {
            if (writer != null && writer.checkError()) {
                log.error("Error writing to OpenTSDB, clearing OpenTSDB socket pool");
                this.pool.invalidateObject((Object)this.address, (Object)socket);
            } else {
                this.pool.returnObject((Object)this.address, (Object)socket);
            }
        }
    }

    @Inject
    public void setPool(GenericKeyedObjectPool<InetSocketAddress, Socket> pool) {
        this.pool = pool;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final ImmutableList.Builder<String> typeNames = ImmutableList.builder();
        private boolean booleanAsNumber;
        private Boolean debugEnabled;
        private String host;
        private Integer port;
        private final ImmutableMap.Builder<String, String> tags = ImmutableMap.builder();
        private String tagName;
        private Boolean mergeTypeNamesTags;
        private String metricNamingExpression;
        private Boolean addHostnameTag = true;

        private Builder() {
        }

        public Builder addTypeNames(List<String> typeNames) {
            this.typeNames.addAll(typeNames);
            return this;
        }

        public Builder addTypeName(String typeName) {
            this.typeNames.add((Object)typeName);
            return this;
        }

        public Builder setBooleanAsNumber(boolean booleanAsNumber) {
            this.booleanAsNumber = booleanAsNumber;
            return this;
        }

        public Builder setDebugEnabled(boolean debugEnabled) {
            this.debugEnabled = debugEnabled;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder addTag(String key, String value) {
            this.tags.put((Object)key, (Object)value);
            return this;
        }

        public Builder addTags(Map<String, String> tags) {
            this.tags.putAll(tags);
            return this;
        }

        public Builder setTagName(String tagName) {
            this.tagName = tagName;
            return this;
        }

        public Builder setMergeTypeNamesTags(Boolean mergeTypeNamesTags) {
            this.mergeTypeNamesTags = mergeTypeNamesTags;
            return this;
        }

        public Builder setMetricNamingExpression(String metricNamingExpression) {
            this.metricNamingExpression = metricNamingExpression;
            return this;
        }

        public Builder setAddHostnameTag(Boolean addHostnameTag) {
            this.addHostnameTag = addHostnameTag;
            return this;
        }

        public OpenTSDBWriter build() throws LifecycleException, UnknownHostException {
            return new OpenTSDBWriter((ImmutableList<String>)this.typeNames.build(), this.booleanAsNumber, this.debugEnabled, this.host, this.port, (Map<String, String>)this.tags.build(), this.tagName, this.mergeTypeNamesTags, this.metricNamingExpression, this.addHostnameTag, null);
        }
    }
}

