/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.ResultAttribute;
import com.googlecode.jmxtrans.model.ResultAttributes;
import com.googlecode.jmxtrans.model.output.StatsDTelegrafWriter;
import com.googlecode.jmxtrans.model.output.support.UdpOutputWriterBuilder;
import com.googlecode.jmxtrans.model.output.support.WriterPoolOutputWriter;
import com.googlecode.jmxtrans.model.output.support.pool.FlushStrategy;
import com.googlecode.jmxtrans.model.output.support.pool.FlushStrategyUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsDTelegrafWriterFactory
implements OutputWriterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StatsDTelegrafWriterFactory.class);
    @Nonnull
    private final String[] bucketTypes;
    @Nonnull
    private final InetSocketAddress server;
    @Nonnull
    private final FlushStrategy flushStrategy;
    private final int poolSize;
    private final ImmutableSet<ResultAttribute> resultAttributesToWriteAsTags;
    private final ImmutableMap<String, String> tags;

    public StatsDTelegrafWriterFactory(@JsonProperty(value="bucketType") String bucketType, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="tags") ImmutableMap<String, String> tags, @JsonProperty(value="resultTags") List<String> resultTags, @JsonProperty(value="flushStrategy") String flushStrategy, @JsonProperty(value="flushDelayInSeconds") Integer flushDelayInSeconds, @JsonProperty(value="poolSize") Integer poolSize) {
        this.bucketTypes = StringUtils.split((String)((String)MoreObjects.firstNonNull((Object)bucketType, (Object)"c")), (String)",");
        this.server = new InetSocketAddress((String)Preconditions.checkNotNull((Object)host, (Object)"Host cannot be null."), (int)((Integer)Preconditions.checkNotNull((Object)port, (Object)"Port cannot be null.")));
        this.resultAttributesToWriteAsTags = this.initResultAttributesToWriteAsTags(resultTags);
        this.tags = this.initCustomTagsMap(tags);
        this.flushStrategy = FlushStrategyUtils.createFlushStrategy(flushStrategy, flushDelayInSeconds);
        this.poolSize = (Integer)MoreObjects.firstNonNull((Object)poolSize, (Object)1);
    }

    private ImmutableMap<String, String> initCustomTagsMap(ImmutableMap<String, String> tags) {
        return ImmutableMap.copyOf((Map)((Map)MoreObjects.firstNonNull(tags, Collections.emptyMap())));
    }

    private ImmutableSet<ResultAttribute> initResultAttributesToWriteAsTags(List<String> resultTags) {
        ImmutableSet result = resultTags == null ? ImmutableSet.copyOf((Collection)ResultAttributes.values()) : ResultAttributes.forNames(resultTags);
        LOG.debug("Result Tags to write set to: {}", (Object)result);
        return result;
    }

    public WriterPoolOutputWriter<StatsDTelegrafWriter> create() {
        return UdpOutputWriterBuilder.builder(this.server, new StatsDTelegrafWriter(this.bucketTypes, this.tags, this.resultAttributesToWriteAsTags)).setCharset(Charsets.UTF_8).setFlushStrategy(this.flushStrategy).setPoolSize(this.poolSize).build();
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatsDTelegrafWriterFactory)) {
            return false;
        }
        StatsDTelegrafWriterFactory other = (StatsDTelegrafWriterFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.bucketTypes, other.bucketTypes)) {
            return false;
        }
        InetSocketAddress this$server = this.server;
        InetSocketAddress other$server = other.server;
        if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
            return false;
        }
        FlushStrategy this$flushStrategy = this.flushStrategy;
        FlushStrategy other$flushStrategy = other.flushStrategy;
        if (this$flushStrategy == null ? other$flushStrategy != null : !this$flushStrategy.equals(other$flushStrategy)) {
            return false;
        }
        if (this.poolSize != other.poolSize) {
            return false;
        }
        ImmutableSet<ResultAttribute> this$resultAttributesToWriteAsTags = this.resultAttributesToWriteAsTags;
        ImmutableSet<ResultAttribute> other$resultAttributesToWriteAsTags = other.resultAttributesToWriteAsTags;
        if (this$resultAttributesToWriteAsTags == null ? other$resultAttributesToWriteAsTags != null : !this$resultAttributesToWriteAsTags.equals(other$resultAttributesToWriteAsTags)) {
            return false;
        }
        ImmutableMap<String, String> this$tags = this.tags;
        ImmutableMap<String, String> other$tags = other.tags;
        return !(this$tags == null ? other$tags != null : !this$tags.equals(other$tags));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof StatsDTelegrafWriterFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.bucketTypes);
        InetSocketAddress $server = this.server;
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        FlushStrategy $flushStrategy = this.flushStrategy;
        result = result * 59 + ($flushStrategy == null ? 43 : $flushStrategy.hashCode());
        result = result * 59 + this.poolSize;
        ImmutableSet<ResultAttribute> $resultAttributesToWriteAsTags = this.resultAttributesToWriteAsTags;
        result = result * 59 + ($resultAttributesToWriteAsTags == null ? 43 : $resultAttributesToWriteAsTags.hashCode());
        ImmutableMap<String, String> $tags = this.tags;
        result = result * 59 + ($tags == null ? 43 : $tags.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "StatsDTelegrafWriterFactory(bucketTypes=" + Arrays.deepToString(this.bucketTypes) + ", server=" + this.server + ", flushStrategy=" + this.flushStrategy + ", poolSize=" + this.poolSize + ", resultAttributesToWriteAsTags=" + this.resultAttributesToWriteAsTags + ", tags=" + this.tags + ")";
    }
}

