/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HttpUrlConnectionConfigurer {
    @Nonnull
    private final String requestMethod;
    private final int readTimeoutInMillis;
    @Nullable
    private final String authorization;
    @Nonnull
    private final String userAgent;
    @Nullable
    private final String contentType;

    public HttpUrlConnectionConfigurer(@Nonnull String requestMethod, int readTimeoutInMillis, @Nullable String authorization, @Nullable String contentType) {
        Preconditions.checkArgument((boolean)this.methodIsValid(requestMethod), (String)"%s is not a supported HTTP method", (Object)requestMethod);
        this.requestMethod = requestMethod;
        this.readTimeoutInMillis = readTimeoutInMillis;
        this.authorization = authorization;
        this.userAgent = "jmxtrans-standalone/1 (" + System.getProperty("java.vm.name") + "/" + System.getProperty("java.version") + "; " + System.getProperty("os.name") + "-" + System.getProperty("os.arch") + "/" + System.getProperty("os.version") + ")";
        this.contentType = contentType;
    }

    public void configure(HttpURLConnection httpURLConnection) throws ProtocolException {
        httpURLConnection.setRequestMethod(this.requestMethod);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setReadTimeout(this.readTimeoutInMillis);
        if (this.contentType != null) {
            httpURLConnection.setRequestProperty("Content-Type", this.contentType);
        }
        if (this.authorization != null) {
            httpURLConnection.setRequestProperty("Authorization", this.authorization);
        }
        httpURLConnection.setRequestProperty("User-Agent", this.userAgent);
    }

    private boolean methodIsValid(String requestMethod) {
        return requestMethod != null && requestMethod.equals("POST");
    }

    public static Builder builder(String requestMethod) {
        return new Builder(requestMethod);
    }

    public static final class Builder {
        @Nonnull
        private final String requestMethod;
        private int readTimeoutInMillis = 100;
        @Nullable
        private String authorization = null;
        @Nullable
        private String contentType = null;

        public Builder(@Nonnull String requestMethod) {
            this.requestMethod = requestMethod;
        }

        public HttpUrlConnectionConfigurer build() {
            return new HttpUrlConnectionConfigurer(this.requestMethod, this.readTimeoutInMillis, this.authorization, this.contentType);
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setReadTimeoutInMillis(int readTimeoutInMillis) {
            this.readTimeoutInMillis = readTimeoutInMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setAuthorization(@Nullable String authorization) {
            this.authorization = authorization;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public Builder setContentType(@Nullable String contentType) {
            this.contentType = contentType;
            return this;
        }
    }
}

