/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.support.pool;

import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stormpot.Allocator;
import stormpot.Poolable;
import stormpot.Slot;

public class RetryingAllocator<V extends Poolable>
implements Allocator<V> {
    private static final Logger log = LoggerFactory.getLogger(RetryingAllocator.class);
    private static final long WAIT_INTERVAL_MS = 100L;
    private static final long MAX_WAIT_MS = TimeUnit.SECONDS.toMillis(60L);
    @Nonnull
    private final Allocator<V> allocator;
    @Nonnull
    private final Retryer<V> retryer;

    public RetryingAllocator(Allocator<V> allocator) {
        this(allocator, 100L, MAX_WAIT_MS);
    }

    public RetryingAllocator(Allocator<V> allocator, long waitInterval, long maxWaitInterval) {
        this.allocator = allocator;
        this.retryer = RetryerBuilder.newBuilder().retryIfException().withWaitStrategy(WaitStrategies.fixedWait((long)waitInterval, (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(StopStrategies.stopAfterDelay((long)maxWaitInterval, (TimeUnit)TimeUnit.MILLISECONDS)).withRetryListener(new RetryListener(){

            public <V> void onRetry(Attempt<V> attempt) {
                if (attempt.hasException()) {
                    log.error("Error allocating slot", attempt.getExceptionCause());
                }
            }
        }).build();
    }

    public V allocate(final Slot slot) throws Exception {
        return (V)((Poolable)this.retryer.call(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return RetryingAllocator.this.allocator.allocate(slot);
            }
        }));
    }

    public void deallocate(V poolable) throws Exception {
        this.allocator.deallocate(poolable);
    }
}

