/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.elastic;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.googlecode.jmxtrans.exceptions.LifecycleException;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.model.output.elastic.ElasticWriterException;
import com.googlecode.jmxtrans.util.NumberUtils;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.core.Index;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.IndicesExists;
import io.searchbox.indices.mapping.PutMapping;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ElasticWriter
extends BaseOutputWriter {
    private static final Logger log = LoggerFactory.getLogger(ElasticWriter.class);
    private static final String DEFAULT_ROOT_PREFIX = "jmxtrans";
    private static final String ELASTIC_TYPE_NAME = "jmx-entry";
    private static final Object CREATE_MAPPING_LOCK = new Object();
    private JestClient jestClient;
    private final String rootPrefix;
    private final String connectionUrl;
    private final String indexName;

    @JsonCreator
    public ElasticWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="rootPrefix") String rootPrefix, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="connectionUrl") String connectionUrl, @JsonProperty(value="settings") Map<String, Object> settings) throws IOException {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.rootPrefix = (String)this.firstNonNull(rootPrefix, (String)this.getSettings().get("rootPrefix"), DEFAULT_ROOT_PREFIX);
        this.connectionUrl = connectionUrl;
        this.indexName = this.rootPrefix + "_jmx-entries";
        this.jestClient = this.createJestClient(connectionUrl);
    }

    private JestClient createJestClient(String connectionUrl) {
        log.info("Create a jest elastic search client for connection url [{}]", (Object)connectionUrl);
        JestClientFactory factory = new JestClientFactory();
        factory.setHttpClientConfig(((HttpClientConfig.Builder)new HttpClientConfig.Builder(connectionUrl).multiThreaded(true)).build());
        return factory.getObject();
    }

    protected void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        for (Result result : results) {
            log.debug("Query result: [{}]", (Object)result);
            ImmutableMap resultValues = result.getValues();
            for (Map.Entry values : resultValues.entrySet()) {
                Object value = values.getValue();
                if (NumberUtils.isNumeric(value)) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("serverAlias", server.getAlias());
                    map.put("server", server.getHost());
                    map.put("port", server.getPort());
                    map.put("objDomain", result.getObjDomain());
                    map.put("className", result.getClassName());
                    map.put("typeName", result.getTypeName());
                    map.put("attributeName", result.getAttributeName());
                    map.put("key", values.getKey());
                    map.put("keyAlias", result.getKeyAlias());
                    map.put("value", Double.parseDouble(value.toString()));
                    map.put("timestamp", result.getEpoch());
                    log.debug("Insert into Elastic: Index: [{}] Type: [{}] Map: [{}]", new Object[]{this.indexName, ELASTIC_TYPE_NAME, map});
                    Index index = ((Index.Builder)((Index.Builder)new Index.Builder(map).index(this.indexName)).type(ELASTIC_TYPE_NAME)).build();
                    JestResult addToIndex = this.jestClient.execute((Action)index);
                    if (addToIndex.isSucceeded()) continue;
                    throw new ElasticWriterException(String.format("Unable to write entry to elastic: %s", addToIndex.getErrorMessage()));
                }
                log.warn("Unable to submit non-numeric value to Elastic: [{}] from result [{}]", value, (Object)result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createMappingIfNeeded(JestClient jestClient, String indexName, String typeName) throws ElasticWriterException, IOException {
        Object object = CREATE_MAPPING_LOCK;
        synchronized (object) {
            IndicesExists indicesExists = new IndicesExists.Builder(indexName).build();
            boolean indexExists = jestClient.execute((Action)indicesExists).isSucceeded();
            if (!indexExists) {
                CreateIndex createIndex = new CreateIndex.Builder(indexName).build();
                jestClient.execute((Action)createIndex);
                URL url = ElasticWriter.class.getResource("/elastic-mapping.json");
                String mapping = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
                PutMapping putMapping = new PutMapping.Builder(indexName, typeName, (Object)mapping).build();
                JestResult result = jestClient.execute((Action)putMapping);
                if (!result.isSucceeded()) {
                    throw new ElasticWriterException(String.format("Failed to create mapping: %s", result.getErrorMessage()));
                }
                log.info("Created mapping for index {}", (Object)indexName);
            }
        }
    }

    public void start() throws LifecycleException {
        super.start();
        try {
            ElasticWriter.createMappingIfNeeded(this.jestClient, this.indexName, ELASTIC_TYPE_NAME);
        }
        catch (Exception e) {
            throw new LifecycleException("Failed to create elastic mapping.", (Throwable)e);
        }
    }

    public void close() throws LifecycleException {
        super.close();
        this.jestClient.shutdownClient();
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ElasticWriter{");
        sb.append("rootPrefix='").append(this.rootPrefix).append('\'');
        sb.append(", connectionUrl='").append(this.connectionUrl).append('\'');
        sb.append(", indexName='").append(this.indexName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

