/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.model.output.Settings;
import com.googlecode.jmxtrans.model.results.CPrecisionValueTransformer;
import com.googlecode.jmxtrans.model.results.ValueTransformer;
import info.ganglia.gmetric4j.gmetric.GMetric;
import info.ganglia.gmetric4j.gmetric.GMetricSlope;
import info.ganglia.gmetric4j.gmetric.GMetricType;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GangliaWriter
extends BaseOutputWriter {
    private static final Pattern PATTERN_HOST_IP = Pattern.compile("(.+):([^:]+)$");
    private static final Logger log = LoggerFactory.getLogger(GangliaWriter.class);
    public static final String ADDRESSING_MODE = "addressingMode";
    public static final String TTL = "ttl";
    public static final String V31 = "v3.1";
    public static final String UNITS = "units";
    public static final String SLOPE = "slope";
    public static final String TMAX = "tmax";
    public static final String DMAX = "dmax";
    public static final String GROUP_NAME = "groupName";
    public static final String SPOOF_NAME = "spoofedHostName";
    public static final int DEFAULT_PORT = 8649;
    public static final GMetric.UDPAddressingMode DEFAULT_ADDRESSING_MODE = GMetric.UDPAddressingMode.UNICAST;
    public static final int DEFAULT_TTL = 5;
    public static final boolean DEFAULT_V31 = true;
    public static final String DEFAULT_UNITS = "";
    public static final GMetricSlope DEFAULT_SLOPE = GMetricSlope.BOTH;
    public static final int DEFAULT_DMAX = 0;
    public static final int DEFAULT_TMAX = 60;
    public static final String DEFAULT_GROUP_NAME = "JMX";
    private final String host;
    private final int port;
    private final GMetric.UDPAddressingMode addressingMode;
    private final int ttl;
    private final boolean v31;
    private final String units;
    private final GMetricSlope slope;
    private final int tmax;
    private final int dmax;
    private final String groupName;
    private String spoofedHostName = null;
    private final ValueTransformer valueTransformer = new CPrecisionValueTransformer();

    @JsonCreator
    public GangliaWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="addressingMode") String addressingMode, @JsonProperty(value="ttl") Integer ttl, @JsonProperty(value="v31") Boolean v31, @JsonProperty(value="units") String units, @JsonProperty(value="slope") String slope, @JsonProperty(value="tmax") Integer tmax, @JsonProperty(value="dmax") Integer dmax, @JsonProperty(value="groupName") String groupName, @JsonProperty(value="settings") Map<String, Object> settings) {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.host = (String)MoreObjects.firstNonNull((Object)host, (Object)((String)this.getSettings().get("host")));
        this.port = (Integer)MoreObjects.firstNonNull((Object)port, (Object)Settings.getIntSetting((Map)this.getSettings(), (String)"port", (int)8649));
        this.addressingMode = this.computeAddressingMode((String)this.firstNonNull(addressingMode, (String)this.getSettings().get(ADDRESSING_MODE), DEFAULT_UNITS), this.host);
        this.ttl = (Integer)MoreObjects.firstNonNull((Object)ttl, (Object)Settings.getIntegerSetting((Map)this.getSettings(), (String)TTL, (Integer)5));
        this.v31 = (Boolean)MoreObjects.firstNonNull((Object)v31, (Object)Settings.getBooleanSetting((Map)this.getSettings(), (String)V31, (Boolean)true));
        this.units = (String)this.firstNonNull(units, (String)this.getSettings().get(UNITS), DEFAULT_UNITS);
        this.slope = GMetricSlope.valueOf((String)((String)this.firstNonNull(slope, (String)this.getSettings().get(SLOPE), DEFAULT_SLOPE.name())));
        this.tmax = (Integer)MoreObjects.firstNonNull((Object)tmax, (Object)Settings.getIntegerSetting((Map)this.getSettings(), (String)TMAX, (Integer)60));
        this.dmax = (Integer)MoreObjects.firstNonNull((Object)dmax, (Object)Settings.getIntegerSetting((Map)this.getSettings(), (String)DMAX, (Integer)0));
        this.groupName = (String)this.firstNonNull(groupName, (String)this.getSettings().get(GROUP_NAME), DEFAULT_GROUP_NAME);
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
        this.spoofedHostName = GangliaWriter.getSpoofedHostName(server.getHost(), server.getAlias());
        log.debug("Validated Ganglia metric [host: " + this.host + ", " + "port" + ": " + this.port + ", " + ADDRESSING_MODE + ": " + this.addressingMode + ", " + TTL + ": " + this.ttl + ", " + V31 + ": " + this.v31 + ", " + UNITS + ": '" + this.units + "', " + SLOPE + ": " + this.slope + ", " + TMAX + ": " + this.tmax + ", " + DMAX + ": " + this.dmax + ", " + SPOOF_NAME + ": " + this.spoofedHostName + ", " + GROUP_NAME + ": '" + this.groupName + "']");
    }

    private GMetric.UDPAddressingMode computeAddressingMode(String mode, String host) {
        try {
            return GMetric.UDPAddressingMode.valueOf((String)mode);
        }
        catch (IllegalArgumentException iae) {
            try {
                return GMetric.UDPAddressingMode.getModeForAddress((String)host);
            }
            catch (UnknownHostException uhe) {
                return DEFAULT_ADDRESSING_MODE;
            }
            catch (IOException ioe) {
                return DEFAULT_ADDRESSING_MODE;
            }
        }
    }

    public void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        for (Result result : results) {
            if (result.getValues() == null) continue;
            for (Map.Entry resultValue : result.getValues().entrySet()) {
                String name = KeyUtils.getKeyString((Query)query, (Result)result, (Map.Entry)resultValue, (List)this.getTypeNames());
                Object transformedValue = this.valueTransformer.apply(resultValue.getValue());
                GMetricType dataType = GangliaWriter.getType(resultValue.getValue());
                log.debug("Sending Ganglia metric {}={} [type={}]", new Object[]{name, transformedValue, dataType});
                new GMetric(this.host, this.port, this.addressingMode, this.ttl, this.v31, null, this.spoofedHostName).announce(name, transformedValue.toString(), dataType, this.units, this.slope, this.tmax, this.dmax, this.groupName);
            }
        }
    }

    public static String getSpoofedHostName(String host, String alias) {
        String spoofed = host;
        if (StringUtils.isNotEmpty((String)alias)) {
            Matcher hostIpMatcher = PATTERN_HOST_IP.matcher(alias);
            if (hostIpMatcher.matches()) {
                return alias;
            }
            spoofed = alias;
        }
        try {
            return InetAddress.getByName(spoofed).getHostAddress() + ":" + spoofed;
        }
        catch (UnknownHostException e) {
            try {
                return InetAddress.getLocalHost().getHostAddress() + ":" + spoofed;
            }
            catch (UnknownHostException unknownHostException) {
                return "x:" + spoofed;
            }
        }
    }

    private static GMetricType getType(Object obj) {
        if (obj instanceof Long || obj instanceof Integer || obj instanceof Byte || obj instanceof Short) {
            return GMetricType.INT32;
        }
        if (obj instanceof Float) {
            return GMetricType.FLOAT;
        }
        if (obj instanceof Double) {
            return GMetricType.DOUBLE;
        }
        try {
            Double.parseDouble(obj.toString());
            return GMetricType.DOUBLE;
        }
        catch (NumberFormatException e) {
            try {
                Integer.parseInt(obj.toString());
                return GMetricType.UINT32;
            }
            catch (NumberFormatException numberFormatException) {
                return GMetricType.STRING;
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getAddressingMode() {
        return this.addressingMode.name();
    }

    public int getTtl() {
        return this.ttl;
    }

    public boolean isV31() {
        return this.v31;
    }

    public String getUnits() {
        return this.units;
    }

    public GMetricSlope getSlope() {
        return this.slope;
    }

    public int getTmax() {
        return this.tmax;
    }

    public int getDmax() {
        return this.dmax;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final ImmutableList.Builder<String> typeNames = ImmutableList.builder();
        private boolean booleanAsNumber;
        private Boolean debugEnabled;
        private String host;
        private Integer port;
        private String addressingMode;
        private Integer ttl;
        private Boolean v31;
        private String units;
        private String slope;
        private Integer tmax;
        private Integer dmax;
        private String groupName;

        private Builder() {
        }

        public Builder addTypeNames(List<String> typeNames) {
            this.typeNames.addAll(typeNames);
            return this;
        }

        public Builder addTypeName(String typeName) {
            this.typeNames.add((Object)typeName);
            return this;
        }

        public Builder setBooleanAsNumber(boolean booleanAsNumber) {
            this.booleanAsNumber = booleanAsNumber;
            return this;
        }

        public Builder setDebugEnabled(boolean debugEnabled) {
            this.debugEnabled = debugEnabled;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setAddressingMode(String addressingMode) {
            this.addressingMode = addressingMode;
            return this;
        }

        public Builder setTtl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder setV31(Boolean v31) {
            this.v31 = v31;
            return this;
        }

        public Builder setUnits(String units) {
            this.units = units;
            return this;
        }

        public Builder setSlope(String slope) {
            this.slope = slope;
            return this;
        }

        public Builder setTmax(Integer tmax) {
            this.tmax = tmax;
            return this;
        }

        public Builder setDmax(Integer dmax) {
            this.dmax = dmax;
            return this;
        }

        public Builder setGroupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public GangliaWriter build() {
            return new GangliaWriter((ImmutableList<String>)this.typeNames.build(), this.booleanAsNumber, this.debugEnabled, this.host, this.port, this.addressingMode, this.ttl, this.v31, this.units, this.slope, this.tmax, this.dmax, this.groupName, null);
        }
    }
}

