/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.gelf;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.output.gelf.GelfWriter;
import java.io.File;
import java.util.Map;
import javax.annotation.Nonnull;
import org.graylog2.gelfclient.GelfConfiguration;
import org.graylog2.gelfclient.GelfTransports;
import org.graylog2.gelfclient.transport.GelfTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GelfWriterFactory
implements OutputWriterFactory {
    private final ImmutableList<String> typeNames;
    private final GelfConfiguration gelfConfiguration;
    private final Map<String, Object> additionalFields;
    private static final Logger log = LoggerFactory.getLogger(GelfWriter.class);

    public GelfWriterFactory(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="host") String host, @JsonProperty(value="port") Integer port, @JsonProperty(value="additionalFields") Map<String, Object> additionalFields, @JsonProperty(value="transport") String transport, @JsonProperty(value="queueSize") Integer queueSize, @JsonProperty(value="connectTimeout") Integer connectTimeout, @JsonProperty(value="reconnectDelay") Integer reconnectDelay, @JsonProperty(value="tcpNoDelay") Boolean tcpNoDelay, @JsonProperty(value="sendBufferSize") Integer sendBufferSize, @JsonProperty(value="tlsEnabled") Boolean tlsEnabled, @JsonProperty(value="tlsTrustCertChainFile") String tlsTrustCertChainFile, @JsonProperty(value="tlsCertVerificationEnabled") Boolean tlsCertVerificationEnabled, @JsonProperty(value="tcpKeepAlive") Boolean tcpKeepAlive, @JsonProperty(value="maxInflightSends") Integer maxInflightSends) {
        this.typeNames = typeNames;
        this.additionalFields = additionalFields;
        if (host == null) {
            throw new NullPointerException("Host can not be null");
        }
        this.gelfConfiguration = port != null ? new GelfConfiguration(host, port.intValue()) : new GelfConfiguration(host);
        if (transport != null) {
            GelfTransports gelfTransports;
            switch (transport.toUpperCase()) {
                case "TCP": {
                    gelfTransports = GelfTransports.TCP;
                    break;
                }
                case "UDP": {
                    gelfTransports = GelfTransports.UDP;
                    break;
                }
                default: {
                    gelfTransports = GelfTransports.TCP;
                }
            }
            this.gelfConfiguration.transport(gelfTransports);
        }
        if (queueSize != null) {
            this.gelfConfiguration.queueSize(queueSize.intValue());
        }
        if (connectTimeout != null) {
            this.gelfConfiguration.connectTimeout(connectTimeout.intValue());
        }
        if (reconnectDelay != null) {
            this.gelfConfiguration.reconnectDelay(reconnectDelay.intValue());
        }
        if (tcpNoDelay != null) {
            this.gelfConfiguration.tcpNoDelay(tcpNoDelay.booleanValue());
        }
        if (sendBufferSize != null) {
            this.gelfConfiguration.sendBufferSize(sendBufferSize.intValue());
        }
        if (tlsEnabled != null) {
            if (tlsEnabled.booleanValue()) {
                this.gelfConfiguration.enableTls();
            } else {
                this.gelfConfiguration.disableTls();
            }
        }
        if (tlsCertVerificationEnabled != null) {
            if (tlsCertVerificationEnabled.booleanValue()) {
                this.gelfConfiguration.enableTlsCertVerification();
            } else {
                this.gelfConfiguration.disableTlsCertVerification();
            }
        }
        if (tlsTrustCertChainFile != null) {
            this.gelfConfiguration.tlsTrustCertChainFile(new File(tlsTrustCertChainFile));
        }
        if (tcpKeepAlive != null) {
            this.gelfConfiguration.tcpKeepAlive(tcpKeepAlive.booleanValue());
        }
        if (maxInflightSends != null) {
            this.gelfConfiguration.maxInflightSends(maxInflightSends.intValue());
        }
        log.debug("Created gelf configuration: {}", (Object)this.gelfConfiguration.toString());
    }

    @Nonnull
    public GelfWriter create() {
        GelfTransport gelfTransport = GelfTransports.create((GelfConfiguration)this.gelfConfiguration);
        return new GelfWriter(this.typeNames, this.additionalFields, gelfTransport);
    }

    @VisibleForTesting
    public GelfConfiguration getGelfConfiguration() {
        return this.gelfConfiguration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GelfWriterFactory)) {
            return false;
        }
        GelfWriterFactory other = (GelfWriterFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ImmutableList<String> this$typeNames = this.typeNames;
        ImmutableList<String> other$typeNames = other.typeNames;
        if (this$typeNames == null ? other$typeNames != null : !this$typeNames.equals(other$typeNames)) {
            return false;
        }
        GelfConfiguration this$gelfConfiguration = this.getGelfConfiguration();
        GelfConfiguration other$gelfConfiguration = other.getGelfConfiguration();
        if (this$gelfConfiguration == null ? other$gelfConfiguration != null : !this$gelfConfiguration.equals(other$gelfConfiguration)) {
            return false;
        }
        Map<String, Object> this$additionalFields = this.additionalFields;
        Map<String, Object> other$additionalFields = other.additionalFields;
        return !(this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GelfWriterFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImmutableList<String> $typeNames = this.typeNames;
        result = result * 59 + ($typeNames == null ? 43 : $typeNames.hashCode());
        GelfConfiguration $gelfConfiguration = this.getGelfConfiguration();
        result = result * 59 + ($gelfConfiguration == null ? 43 : $gelfConfiguration.hashCode());
        Map<String, Object> $additionalFields = this.additionalFields;
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        return result;
    }
}

