/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output.gelf;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.googlecode.jmxtrans.model.OutputWriterAdapter;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.graylog2.gelfclient.GelfMessageBuilder;
import org.graylog2.gelfclient.transport.GelfTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GelfWriter
extends OutputWriterAdapter {
    private static final Logger log = LoggerFactory.getLogger(GelfWriter.class);
    private final Map<String, Object> additionalFields;
    private final GelfTransport gelfTransport;
    private final ImmutableList<String> typeNames;

    public GelfWriter(ImmutableList<String> typeNames, Map<String, Object> additionalFields, GelfTransport gelfTransport) {
        this.typeNames = typeNames;
        this.additionalFields = additionalFields;
        this.gelfTransport = gelfTransport;
    }

    public void doWrite(Server server, Query query, Iterable<Result> results) throws Exception {
        GelfMessageBuilder messageBuilder = new GelfMessageBuilder("", server.getHost());
        ArrayList<String> messages = new ArrayList<String>();
        for (Result result : results) {
            log.debug("Query result: [{}]", (Object)result);
            String key = KeyUtils.getKeyString((Query)query, (Result)result, this.typeNames);
            messages.add(String.format("%s=%s", key, result.getValue()));
            messageBuilder.additionalField(key, result.getValue());
        }
        if (this.additionalFields != null) {
            for (Map.Entry entry : this.additionalFields.entrySet()) {
                messageBuilder.additionalField((String)entry.getKey(), entry.getValue());
            }
        }
        String message = StringUtils.join(messages, (String)" ");
        messageBuilder.message(message);
        messageBuilder.fullMessage(message);
        log.debug("Sending GELF message: {}", (Object)messageBuilder.build().toString());
        this.gelfTransport.send(messageBuilder.build());
    }

    @VisibleForTesting
    public Map<String, Object> getAdditionalFields() {
        return this.additionalFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GelfWriter)) {
            return false;
        }
        GelfWriter other = (GelfWriter)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map<String, Object> this$additionalFields = this.getAdditionalFields();
        Map<String, Object> other$additionalFields = other.getAdditionalFields();
        if (this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields)) {
            return false;
        }
        GelfTransport this$gelfTransport = this.gelfTransport;
        GelfTransport other$gelfTransport = other.gelfTransport;
        if (this$gelfTransport == null ? other$gelfTransport != null : !this$gelfTransport.equals(other$gelfTransport)) {
            return false;
        }
        ImmutableList<String> this$typeNames = this.typeNames;
        ImmutableList<String> other$typeNames = other.typeNames;
        return !(this$typeNames == null ? other$typeNames != null : !this$typeNames.equals(other$typeNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GelfWriter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        GelfTransport $gelfTransport = this.gelfTransport;
        result = result * 59 + ($gelfTransport == null ? 43 : $gelfTransport.hashCode());
        ImmutableList<String> $typeNames = this.typeNames;
        result = result * 59 + ($typeNames == null ? 43 : $typeNames.hashCode());
        return result;
    }
}

