/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.googlecode.jmxtrans.model.OutputWriterAdapter;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.ResultAttribute;
import com.googlecode.jmxtrans.model.Server;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.influxdb.InfluxDB;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class InfluxDbWriter
extends OutputWriterAdapter {
    public static final String TAG_HOSTNAME = "hostname";
    @Nonnull
    private final InfluxDB influxDB;
    @Nonnull
    private final String database;
    @Nonnull
    private final InfluxDB.ConsistencyLevel writeConsistency;
    @Nonnull
    private final String retentionPolicy;
    private final ImmutableSet<ResultAttribute> resultAttributesToWriteAsTags;
    private static final Logger log = LoggerFactory.getLogger(InfluxDbWriter.class);
    Predicate<Object> isNotNaN = new Predicate<Object>(){

        public boolean apply(Object input) {
            return !input.toString().equals("NaN");
        }
    };

    public InfluxDbWriter(@Nonnull InfluxDB influxDB, @Nonnull String database, @Nonnull InfluxDB.ConsistencyLevel writeConsistency, @Nonnull String retentionPolicy, @Nonnull ImmutableSet<ResultAttribute> resultAttributesToWriteAsTags) {
        this.database = database;
        this.writeConsistency = writeConsistency;
        this.retentionPolicy = retentionPolicy;
        this.influxDB = influxDB;
        this.resultAttributesToWriteAsTags = resultAttributesToWriteAsTags;
    }

    public void doWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        this.influxDB.createDatabase(this.database);
        BatchPoints batchPoints = BatchPoints.database((String)this.database).retentionPolicy(this.retentionPolicy).tag(TAG_HOSTNAME, server.getSource()).consistency(this.writeConsistency).build();
        for (Result result : results) {
            HashMap<String, Integer> filteredValues = new HashMap<String, Integer>(Maps.filterValues((Map)result.getValues(), this.isNotNaN));
            if (filteredValues.isEmpty()) continue;
            filteredValues.put("_jmx_port", Integer.parseInt(server.getPort()));
            Map<String, String> resultTagsToApply = this.buildResultTagMap(result);
            Point point = Point.measurement((String)result.getKeyAlias()).time(result.getEpoch(), TimeUnit.MILLISECONDS).tag(resultTagsToApply).fields(filteredValues).build();
            batchPoints.point(point);
        }
        this.influxDB.write(batchPoints);
    }

    private Map<String, String> buildResultTagMap(Result result) throws Exception {
        TreeMap<String, String> resultTagMap = new TreeMap<String, String>();
        for (ResultAttribute resultAttribute : this.resultAttributesToWriteAsTags) {
            resultAttribute.addAttribute(resultTagMap, result);
        }
        return resultTagMap;
    }
}

