/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.googlecode.jmxtrans.model.OutputWriterAdapter;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.ResultAttribute;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.util.NumberUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.influxdb.InfluxDB;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class InfluxDbWriter
extends OutputWriterAdapter {
    private static final Logger log = LoggerFactory.getLogger(InfluxDbWriter.class);
    public static final String TAG_HOSTNAME = "hostname";
    @Nonnull
    private final InfluxDB influxDB;
    @Nonnull
    private final String database;
    @Nonnull
    private final InfluxDB.ConsistencyLevel writeConsistency;
    @Nonnull
    private final String retentionPolicy;
    @Nonnull
    private final ImmutableMap<String, String> tags;
    @Nonnull
    ImmutableList<String> typeNames;
    private final ImmutableSet<ResultAttribute> resultAttributesToWriteAsTags;
    private final boolean createDatabase;
    private final Predicate<Object> isNotNaN = new Predicate<Object>(){

        public boolean apply(Object input) {
            return !input.toString().equals("NaN");
        }
    };

    public InfluxDbWriter(@Nonnull InfluxDB influxDB, @Nonnull String database, @Nonnull InfluxDB.ConsistencyLevel writeConsistency, @Nonnull String retentionPolicy, @Nonnull ImmutableMap<String, String> tags, @Nonnull ImmutableSet<ResultAttribute> resultAttributesToWriteAsTags, @Nonnull ImmutableList<String> typeNames, boolean createDatabase) {
        this.typeNames = typeNames;
        this.database = database;
        this.writeConsistency = writeConsistency;
        this.retentionPolicy = retentionPolicy;
        this.influxDB = influxDB;
        this.tags = tags;
        this.resultAttributesToWriteAsTags = resultAttributesToWriteAsTags;
        this.createDatabase = createDatabase;
    }

    public void doWrite(Server server, Query query, Iterable<Result> results) throws Exception {
        if (this.createDatabase) {
            this.influxDB.createDatabase(this.database);
        }
        BatchPoints.Builder batchPointsBuilder = BatchPoints.database((String)this.database).retentionPolicy(this.retentionPolicy).tag(TAG_HOSTNAME, server.getSource());
        for (Map.Entry tag : this.tags.entrySet()) {
            batchPointsBuilder.tag((String)tag.getKey(), (String)tag.getValue());
        }
        BatchPoints batchPoints = batchPointsBuilder.consistency(this.writeConsistency).build();
        for (Result result : results) {
            log.debug("Query result: {}", (Object)result);
            ImmutableMap resultValues = result.getValues();
            HashMap filteredValues = Maps.newHashMap();
            for (Map.Entry values : resultValues.entrySet()) {
                Object value = values.getValue();
                if (!NumberUtils.isValidNumber(value)) continue;
                String key = KeyUtils.getPrefixedKeyString((Query)query, (Result)result, values, this.typeNames, (String)((String)values.getKey()));
                filteredValues.put(key, value);
            }
            if (filteredValues.isEmpty()) continue;
            filteredValues.put("_jmx_port", Integer.parseInt(server.getPort()));
            Map<String, String> resultTagsToApply = this.buildResultTagMap(result);
            Point point = Point.measurement((String)result.getKeyAlias()).time(result.getEpoch(), TimeUnit.MILLISECONDS).tag(resultTagsToApply).fields((Map)filteredValues).build();
            log.debug("Point: {}", (Object)point);
            batchPoints.point(point);
        }
        this.influxDB.write(batchPoints);
    }

    private Map<String, String> buildResultTagMap(Result result) throws Exception {
        TreeMap<String, String> resultTagMap = new TreeMap<String, String>();
        for (ResultAttribute resultAttribute : this.resultAttributesToWriteAsTags) {
            resultAttribute.addAttribute(resultTagMap, result);
        }
        return resultTagMap;
    }
}

