/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.ResultAttribute;
import com.googlecode.jmxtrans.model.ResultAttributes;
import com.googlecode.jmxtrans.model.output.InfluxDbWriter;
import com.googlecode.jmxtrans.model.output.support.ResultTransformerOutputWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDbWriterFactory
implements OutputWriterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxDbWriterFactory.class);
    private static final String DEFAULT_RETENTION_POLICY = "autogen";
    private final String database;
    private final InfluxDB.ConsistencyLevel writeConsistency;
    private final ImmutableMap<String, String> tags;
    private final String retentionPolicy;
    private final InfluxDB influxDB;
    private final ImmutableSet<ResultAttribute> resultAttributesToWriteAsTags;
    private final boolean booleanAsNumber;
    private final boolean createDatabase;
    private final ImmutableList<String> typeNames;

    @JsonCreator
    public InfluxDbWriterFactory(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="url") String url, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="database") String database, @JsonProperty(value="tags") ImmutableMap<String, String> tags, @JsonProperty(value="writeConsistency") String writeConsistency, @JsonProperty(value="retentionPolicy") String retentionPolicy, @JsonProperty(value="resultTags") List<String> resultTags, @JsonProperty(value="createDatabase") Boolean createDatabase) {
        this.typeNames = typeNames;
        this.booleanAsNumber = booleanAsNumber;
        this.database = database;
        this.createDatabase = (Boolean)MoreObjects.firstNonNull((Object)createDatabase, (Object)Boolean.TRUE);
        this.writeConsistency = StringUtils.isNotBlank((String)writeConsistency) ? InfluxDB.ConsistencyLevel.valueOf((String)writeConsistency) : InfluxDB.ConsistencyLevel.ALL;
        this.retentionPolicy = StringUtils.isNotBlank((String)retentionPolicy) ? retentionPolicy : DEFAULT_RETENTION_POLICY;
        this.resultAttributesToWriteAsTags = this.initResultAttributesToWriteAsTags(resultTags);
        this.tags = this.initCustomTagsMap(tags);
        LOG.debug("Connecting to url: {} as: username: {}", (Object)url, (Object)username);
        this.influxDB = InfluxDBFactory.connect((String)url, (String)username, (String)password);
    }

    private ImmutableMap<String, String> initCustomTagsMap(ImmutableMap<String, String> tags) {
        return ImmutableMap.copyOf((Map)((Map)MoreObjects.firstNonNull(tags, Collections.emptyMap())));
    }

    private ImmutableSet<ResultAttribute> initResultAttributesToWriteAsTags(List<String> resultTags) {
        ImmutableSet result = resultTags == null ? ImmutableSet.copyOf((Collection)ResultAttributes.values()) : ResultAttributes.forNames(resultTags);
        LOG.debug("Result Tags to write set to: {}", (Object)result);
        return result;
    }

    public ResultTransformerOutputWriter<InfluxDbWriter> create() {
        return ResultTransformerOutputWriter.booleanToNumber((boolean)this.booleanAsNumber, (OutputWriter)new InfluxDbWriter(this.influxDB, this.database, this.writeConsistency, this.retentionPolicy, this.tags, this.resultAttributesToWriteAsTags, this.typeNames, this.createDatabase));
    }
}

