/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.googlecode.jmxtrans.model.OutputWriterAdapter;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.ResultAttribute;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.naming.KeyUtils;
import com.googlecode.jmxtrans.util.NumberUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.influxdb.InfluxDB;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class InfluxDbWriter
extends OutputWriterAdapter {
    private static final Logger log = LoggerFactory.getLogger(InfluxDbWriter.class);
    public static final String TAG_HOSTNAME = "hostname";
    public static final String JMX_PORT_KEY = "_jmx_port";
    @Nonnull
    private final InfluxDB influxDB;
    @Nonnull
    private final String database;
    @Nonnull
    private final InfluxDB.ConsistencyLevel writeConsistency;
    @Nonnull
    private final String retentionPolicy;
    @Nonnull
    private final ImmutableMap<String, String> tags;
    @Nonnull
    ImmutableList<String> typeNames;
    private final ImmutableSet<ResultAttribute> resultAttributesToWriteAsTags;
    private final boolean createDatabase;
    private final boolean typeNamesAsTags;
    private final boolean allowStringValues;
    private final boolean reportJmxPortAsTag;

    public InfluxDbWriter(@Nonnull InfluxDB influxDB, @Nonnull String database, @Nonnull InfluxDB.ConsistencyLevel writeConsistency, @Nonnull String retentionPolicy, @Nonnull ImmutableMap<String, String> tags, @Nonnull ImmutableSet<ResultAttribute> resultAttributesToWriteAsTags, @Nonnull ImmutableList<String> typeNames, boolean createDatabase, boolean reportJmxPortAsTag, boolean typeNamesAsTags, boolean allowStringValues) {
        this.typeNames = typeNames;
        this.database = database;
        this.writeConsistency = writeConsistency;
        this.retentionPolicy = retentionPolicy;
        this.influxDB = influxDB;
        this.tags = tags;
        this.resultAttributesToWriteAsTags = resultAttributesToWriteAsTags;
        this.createDatabase = createDatabase;
        this.reportJmxPortAsTag = reportJmxPortAsTag;
        this.typeNamesAsTags = typeNamesAsTags;
        this.allowStringValues = allowStringValues;
    }

    public void doWrite(Server server, Query query, Iterable<Result> results) throws Exception {
        if (this.createDatabase) {
            this.influxDB.createDatabase(this.database);
        }
        BatchPoints.Builder batchPointsBuilder = BatchPoints.database((String)this.database).retentionPolicy(this.retentionPolicy).tag(TAG_HOSTNAME, server.getSource());
        for (Map.Entry tag : this.tags.entrySet()) {
            batchPointsBuilder.tag((String)tag.getKey(), (String)tag.getValue());
        }
        BatchPoints batchPoints = batchPointsBuilder.consistency(this.writeConsistency).build();
        ImmutableList<String> typeNamesParam = null;
        if (!this.typeNamesAsTags) {
            typeNamesParam = this.typeNames;
        }
        for (Result result : results) {
            log.debug("Query result: {}", (Object)result);
            HashMap filteredValues = Maps.newHashMap();
            Object value = result.getValue();
            String key = KeyUtils.getPrefixedKeyString((Query)query, (Result)result, typeNamesParam);
            if (NumberUtils.isValidNumber((Object)value) || this.allowStringValues && value instanceof String) {
                filteredValues.put(key, value);
            }
            if (filteredValues.isEmpty()) continue;
            Map<String, String> resultTagsToApply = this.buildResultTagMap(result);
            if (this.reportJmxPortAsTag) {
                resultTagsToApply.put(JMX_PORT_KEY, server.getPort());
            } else {
                filteredValues.put(JMX_PORT_KEY, Integer.parseInt(server.getPort()));
            }
            Point point = Point.measurement((String)result.getKeyAlias()).time(result.getEpoch(), TimeUnit.MILLISECONDS).tag(resultTagsToApply).fields((Map)filteredValues).build();
            log.debug("Point: {}", (Object)point);
            batchPoints.point(point);
        }
        this.influxDB.write(batchPoints);
    }

    private Map<String, String> buildResultTagMap(Result result) {
        TreeMap<String, String> resultTagMap = new TreeMap<String, String>();
        for (ResultAttribute resultAttribute : this.resultAttributesToWriteAsTags) {
            resultAttribute.addTo(resultTagMap, result);
        }
        if (this.typeNamesAsTags) {
            Map typeNameValueMap = result.getTypeNameMap();
            for (String typeToTag : this.typeNames) {
                if (!typeNameValueMap.containsKey(typeToTag)) continue;
                resultTagMap.put(typeToTag, (String)typeNameValueMap.get(typeToTag));
            }
        }
        return resultTagMap;
    }
}

