/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.googlecode.jmxtrans.model.OutputWriter;
import com.googlecode.jmxtrans.model.OutputWriterFactory;
import com.googlecode.jmxtrans.model.ResultAttribute;
import com.googlecode.jmxtrans.model.ResultAttributes;
import com.googlecode.jmxtrans.model.output.InfluxDbWriter;
import com.googlecode.jmxtrans.model.output.support.ResultTransformerOutputWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDbWriterFactory
implements OutputWriterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(InfluxDbWriterFactory.class);
    @VisibleForTesting
    static final String DEFAULT_RETENTION_POLICY = "autogen";
    private final String database;
    private final InfluxDB.ConsistencyLevel writeConsistency;
    private final ImmutableMap<String, String> tags;
    private final String retentionPolicy;
    private final InfluxDB influxDB;
    private final ImmutableSet<ResultAttribute> resultAttributesToWriteAsTags;
    private final boolean booleanAsNumber;
    private final boolean typeNamesAsTags;
    private final boolean createDatabase;
    private final boolean reportJmxPortAsTag;
    private final ImmutableList<String> typeNames;
    private final boolean allowStringValues;

    @JsonCreator
    public InfluxDbWriterFactory(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="url") String url, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="database") String database, @JsonProperty(value="tags") ImmutableMap<String, String> tags, @JsonProperty(value="writeConsistency") String writeConsistency, @JsonProperty(value="retentionPolicy") String retentionPolicy, @JsonProperty(value="resultTags") List<String> resultTags, @JsonProperty(value="createDatabase") Boolean createDatabase, @JsonProperty(value="reportJmxPortAsTag") Boolean reportJmxPortAsTag, @JsonProperty(value="typeNamesAsTags") Boolean typeNamesAsTags, @JsonProperty(value="allowStringValues") Boolean allowStringValues) {
        this.typeNames = (ImmutableList)MoreObjects.firstNonNull(typeNames, (Object)ImmutableList.of());
        this.booleanAsNumber = booleanAsNumber;
        this.database = database;
        this.createDatabase = (Boolean)MoreObjects.firstNonNull((Object)createDatabase, (Object)Boolean.TRUE);
        this.typeNamesAsTags = (Boolean)MoreObjects.firstNonNull((Object)typeNamesAsTags, (Object)Boolean.FALSE);
        this.allowStringValues = (Boolean)MoreObjects.firstNonNull((Object)allowStringValues, (Object)Boolean.FALSE);
        this.writeConsistency = StringUtils.isNotBlank((String)writeConsistency) ? InfluxDB.ConsistencyLevel.valueOf((String)writeConsistency) : InfluxDB.ConsistencyLevel.ALL;
        this.retentionPolicy = StringUtils.isNotBlank((String)retentionPolicy) ? retentionPolicy : DEFAULT_RETENTION_POLICY;
        this.resultAttributesToWriteAsTags = this.initResultAttributesToWriteAsTags(resultTags);
        this.tags = this.initCustomTagsMap(tags);
        LOG.debug("Connecting to url: {} as: username: {}", (Object)url, (Object)username);
        this.influxDB = InfluxDBFactory.connect((String)url, (String)username, (String)password);
        this.reportJmxPortAsTag = (Boolean)MoreObjects.firstNonNull((Object)reportJmxPortAsTag, (Object)Boolean.FALSE);
    }

    private ImmutableMap<String, String> initCustomTagsMap(ImmutableMap<String, String> tags) {
        return ImmutableMap.copyOf((Map)((Map)MoreObjects.firstNonNull(tags, Collections.emptyMap())));
    }

    private ImmutableSet<ResultAttribute> initResultAttributesToWriteAsTags(List<String> resultTags) {
        ImmutableSet result = resultTags == null ? ImmutableSet.copyOf((Collection)ResultAttributes.values()) : ResultAttributes.forNames(resultTags);
        LOG.debug("Result Tags to write set to: {}", (Object)result);
        return result;
    }

    public ResultTransformerOutputWriter<InfluxDbWriter> create() {
        return ResultTransformerOutputWriter.booleanToNumber((boolean)this.booleanAsNumber, (OutputWriter)new InfluxDbWriter(this.influxDB, this.database, this.writeConsistency, this.retentionPolicy, this.tags, this.resultAttributesToWriteAsTags, this.typeNames, this.createDatabase, this.reportJmxPortAsTag, this.typeNamesAsTags, this.allowStringValues));
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InfluxDbWriterFactory)) {
            return false;
        }
        InfluxDbWriterFactory other = (InfluxDbWriterFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        InfluxDB.ConsistencyLevel this$writeConsistency = this.getWriteConsistency();
        InfluxDB.ConsistencyLevel other$writeConsistency = other.getWriteConsistency();
        if (this$writeConsistency == null ? other$writeConsistency != null : !this$writeConsistency.equals(other$writeConsistency)) {
            return false;
        }
        ImmutableMap<String, String> this$tags = this.getTags();
        ImmutableMap<String, String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !this$tags.equals(other$tags)) {
            return false;
        }
        String this$retentionPolicy = this.getRetentionPolicy();
        String other$retentionPolicy = other.getRetentionPolicy();
        if (this$retentionPolicy == null ? other$retentionPolicy != null : !this$retentionPolicy.equals(other$retentionPolicy)) {
            return false;
        }
        ImmutableSet<ResultAttribute> this$resultAttributesToWriteAsTags = this.getResultAttributesToWriteAsTags();
        ImmutableSet<ResultAttribute> other$resultAttributesToWriteAsTags = other.getResultAttributesToWriteAsTags();
        if (this$resultAttributesToWriteAsTags == null ? other$resultAttributesToWriteAsTags != null : !this$resultAttributesToWriteAsTags.equals(other$resultAttributesToWriteAsTags)) {
            return false;
        }
        if (this.isBooleanAsNumber() != other.isBooleanAsNumber()) {
            return false;
        }
        if (this.isTypeNamesAsTags() != other.isTypeNamesAsTags()) {
            return false;
        }
        if (this.isCreateDatabase() != other.isCreateDatabase()) {
            return false;
        }
        if (this.isReportJmxPortAsTag() != other.isReportJmxPortAsTag()) {
            return false;
        }
        ImmutableList<String> this$typeNames = this.getTypeNames();
        ImmutableList<String> other$typeNames = other.getTypeNames();
        if (this$typeNames == null ? other$typeNames != null : !this$typeNames.equals(other$typeNames)) {
            return false;
        }
        return this.isAllowStringValues() == other.isAllowStringValues();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof InfluxDbWriterFactory;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        InfluxDB.ConsistencyLevel $writeConsistency = this.getWriteConsistency();
        result = result * 59 + ($writeConsistency == null ? 43 : $writeConsistency.hashCode());
        ImmutableMap<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : $tags.hashCode());
        String $retentionPolicy = this.getRetentionPolicy();
        result = result * 59 + ($retentionPolicy == null ? 43 : $retentionPolicy.hashCode());
        ImmutableSet<ResultAttribute> $resultAttributesToWriteAsTags = this.getResultAttributesToWriteAsTags();
        result = result * 59 + ($resultAttributesToWriteAsTags == null ? 43 : $resultAttributesToWriteAsTags.hashCode());
        result = result * 59 + (this.isBooleanAsNumber() ? 79 : 97);
        result = result * 59 + (this.isTypeNamesAsTags() ? 79 : 97);
        result = result * 59 + (this.isCreateDatabase() ? 79 : 97);
        result = result * 59 + (this.isReportJmxPortAsTag() ? 79 : 97);
        ImmutableList<String> $typeNames = this.getTypeNames();
        result = result * 59 + ($typeNames == null ? 43 : $typeNames.hashCode());
        result = result * 59 + (this.isAllowStringValues() ? 79 : 97);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    String getDatabase() {
        return this.database;
    }

    @SuppressFBWarnings(justification="generated code")
    InfluxDB.ConsistencyLevel getWriteConsistency() {
        return this.writeConsistency;
    }

    @SuppressFBWarnings(justification="generated code")
    ImmutableMap<String, String> getTags() {
        return this.tags;
    }

    @SuppressFBWarnings(justification="generated code")
    String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    @SuppressFBWarnings(justification="generated code")
    ImmutableSet<ResultAttribute> getResultAttributesToWriteAsTags() {
        return this.resultAttributesToWriteAsTags;
    }

    @SuppressFBWarnings(justification="generated code")
    boolean isBooleanAsNumber() {
        return this.booleanAsNumber;
    }

    @SuppressFBWarnings(justification="generated code")
    boolean isTypeNamesAsTags() {
        return this.typeNamesAsTags;
    }

    @SuppressFBWarnings(justification="generated code")
    boolean isCreateDatabase() {
        return this.createDatabase;
    }

    @SuppressFBWarnings(justification="generated code")
    boolean isReportJmxPortAsTag() {
        return this.reportJmxPortAsTag;
    }

    @SuppressFBWarnings(justification="generated code")
    ImmutableList<String> getTypeNames() {
        return this.typeNames;
    }

    @SuppressFBWarnings(justification="generated code")
    boolean isAllowStringValues() {
        return this.allowStringValues;
    }
}

