/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.model.ValidationException;
import com.googlecode.jmxtrans.model.output.BaseOutputWriter;
import com.googlecode.jmxtrans.model.output.Settings;
import com.googlecode.jmxtrans.util.NumberUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.jrobin.core.ArcDef;
import org.jrobin.core.DsDef;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdDefTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RRDToolWriter
extends BaseOutputWriter {
    private static final Logger log = LoggerFactory.getLogger(RRDToolWriter.class);
    public static final String GENERATE = "generate";
    private static final char[] INITIALS = new char[]{' ', '.'};
    private final File outputFile;
    private final File templateFile;
    private final File binaryPath;
    private final boolean generate;

    @JsonCreator
    public RRDToolWriter(@JsonProperty(value="typeNames") ImmutableList<String> typeNames, @JsonProperty(value="booleanAsNumber") boolean booleanAsNumber, @JsonProperty(value="debug") Boolean debugEnabled, @JsonProperty(value="outputFile") String outputFile, @JsonProperty(value="templateFile") String templateFile, @JsonProperty(value="binaryPath") String binaryPath, @JsonProperty(value="generate") Boolean generate, @JsonProperty(value="settings") Map<String, Object> settings) {
        super(typeNames, booleanAsNumber, debugEnabled, settings);
        this.outputFile = new File((String)MoreObjects.firstNonNull((Object)outputFile, (Object)((String)this.getSettings().get("outputFile"))));
        this.templateFile = new File((String)MoreObjects.firstNonNull((Object)templateFile, (Object)((String)this.getSettings().get("templateFile"))));
        this.binaryPath = new File((String)MoreObjects.firstNonNull((Object)binaryPath, (Object)((String)this.getSettings().get("binaryPath"))));
        this.generate = (Boolean)MoreObjects.firstNonNull((Object)generate, (Object)Settings.getBooleanSetting((Map)this.getSettings(), (String)GENERATE, (Boolean)Boolean.TRUE));
        Preconditions.checkState((boolean)this.outputFile.exists(), (Object)"Output file must exist");
        Preconditions.checkState((boolean)this.templateFile.exists(), (Object)"Template file must exist");
        Preconditions.checkState((boolean)this.binaryPath.exists(), (Object)"RRD Binary must exist");
    }

    public void validateSetup(Server server, Query query) throws ValidationException {
    }

    public String getDataSourceName(String typeName, String attributeName, String entry) {
        String result = typeName != null ? typeName + attributeName + entry : attributeName + entry;
        if (attributeName.length() > 15) {
            Object[] split = StringUtils.splitByCharacterTypeCamelCase((String)attributeName);
            String join = StringUtils.join((Object[])split, (char)'.');
            attributeName = WordUtils.initials((String)join, (char[])INITIALS);
        }
        result = attributeName + DigestUtils.md5Hex((String)result);
        result = StringUtils.left((String)result, (int)19);
        return result;
    }

    public void internalWrite(Server server, Query query, ImmutableList<Result> results) throws Exception {
        RrdDef def = this.getDatabaseTemplateSpec();
        List<String> dsNames = this.getDsNames(def.getDsDefs());
        TreeMap<String, String> dataMap = new TreeMap<String, String>();
        for (Result res : results) {
            log.debug(res.toString());
            ImmutableMap values = res.getValues();
            if (values == null) continue;
            for (Map.Entry entry : values.entrySet()) {
                String key = this.getDataSourceName(this.getConcatedTypeNameValues(res.getTypeName()), res.getAttributeName(), (String)entry.getKey());
                if (!NumberUtils.isNumeric(entry.getValue())) continue;
                log.debug("Generated DataSource name:value: {} : {}", (Object)key, entry.getValue());
                if (!dsNames.contains(key)) continue;
                dataMap.put(key, entry.getValue().toString());
            }
        }
        this.doGenerate((List<Result>)results);
        if (!dataMap.keySet().isEmpty() && !dataMap.values().isEmpty()) {
            this.rrdToolUpdate(StringUtils.join(dataMap.keySet(), (char)':'), StringUtils.join(dataMap.values(), (char)':'));
        } else {
            log.error("Nothing was logged for query: " + query);
        }
    }

    private void doGenerate(List<Result> results) throws Exception {
        if (this.isDebugEnabled() && this.generate) {
            StringBuilder sb = new StringBuilder("\n");
            ArrayList<String> keys = new ArrayList<String>();
            for (Result res : results) {
                ImmutableMap values = res.getValues();
                if (values == null) continue;
                for (Map.Entry entry : values.entrySet()) {
                    if (!NumberUtils.isNumeric(entry.getValue())) continue;
                    String key = this.getDataSourceName(this.getConcatedTypeNameValues(res.getTypeName()), res.getAttributeName(), (String)entry.getKey());
                    if (keys.contains(key)) {
                        throw new Exception("Duplicate datasource name found: '" + key + "'. Please try to add more typeName keys to the writer to make the name more unique. " + res.toString());
                    }
                    keys.add(key);
                    sb.append("<datasource><!-- ").append(res.getTypeName()).append(":").append(res.getAttributeName()).append(":").append((String)entry.getKey()).append(" --><name>").append(key).append("</name><type>GAUGE</type><heartbeat>400</heartbeat><min>U</min><max>U</max></datasource>\n");
                }
            }
            log.debug(sb.toString());
        }
    }

    protected void rrdToolUpdate(String template, String data) throws Exception {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.binaryPath + "/rrdtool");
        commands.add("update");
        commands.add(this.outputFile.getCanonicalPath());
        commands.add("-t");
        commands.add(template);
        commands.add("N:" + data);
        ProcessBuilder pb = new ProcessBuilder(commands);
        Process process = pb.start();
        this.checkErrorStream(process);
    }

    protected RrdDef getDatabaseTemplateSpec() throws Exception {
        RrdDefTemplate t = new RrdDefTemplate(this.templateFile);
        t.setVariable("database", this.outputFile.getCanonicalPath());
        RrdDef def = t.getRrdDef();
        if (!this.outputFile.exists()) {
            FileUtils.forceMkdir((File)this.outputFile.getParentFile());
            this.rrdToolCreateDatabase(def);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rrdToolCreateDatabase(RrdDef def) throws Exception {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.binaryPath + "/rrdtool");
        commands.add("create");
        commands.add(this.outputFile.getCanonicalPath());
        commands.add("-s");
        commands.add(String.valueOf(def.getStep()));
        for (DsDef dsDef : def.getDsDefs()) {
            commands.add(this.getDsDefStr(dsDef));
        }
        for (DsDef dsDef : def.getArcDefs()) {
            commands.add(this.getRraStr((ArcDef)dsDef));
        }
        ProcessBuilder pb = new ProcessBuilder(commands);
        Process process = pb.start();
        try {
            this.checkErrorStream(process);
        }
        finally {
            IOUtils.closeQuietly((InputStream)process.getInputStream());
            IOUtils.closeQuietly((OutputStream)process.getOutputStream());
            IOUtils.closeQuietly((InputStream)process.getErrorStream());
        }
    }

    private void checkErrorStream(Process process) throws Exception {
        try (Closer closer = Closer.create();){
            String line;
            InputStream is = (InputStream)closer.register((Closeable)process.getErrorStream());
            InputStreamReader isr = (InputStreamReader)closer.register((Closeable)new InputStreamReader(is, Charset.defaultCharset()));
            BufferedReader br = (BufferedReader)closer.register((Closeable)new BufferedReader(isr));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            if (sb.length() > 0) {
                throw new RuntimeException(sb.toString());
            }
        }
    }

    private String getRraStr(ArcDef def) {
        return "RRA:" + def.getConsolFun() + ":" + def.getXff() + ":" + def.getSteps() + ":" + def.getRows();
    }

    private String getDsDefStr(DsDef def) {
        return "DS:" + def.getDsName() + ":" + def.getDsType() + ":" + def.getHeartbeat() + ":" + this.formatDouble(def.getMinValue()) + ":" + this.formatDouble(def.getMaxValue());
    }

    private List<String> getDsNames(DsDef[] defs) {
        ArrayList<String> names = new ArrayList<String>();
        for (DsDef def : defs) {
            names.add(def.getDsName());
        }
        return names;
    }

    private String formatDouble(double dbl) {
        if (Double.isNaN(dbl)) {
            return "U";
        }
        return String.valueOf(dbl);
    }

    public String getOutputFile() {
        return this.outputFile.getPath();
    }

    public String getTemplateFile() {
        return this.templateFile.getPath();
    }

    public String getBinaryPath() {
        return this.binaryPath.getPath();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final ImmutableList.Builder<String> typeNames = ImmutableList.builder();
        private boolean booleanAsNumber;
        private Boolean debugEnabled;
        private File outputFile;
        private File templateFile;
        private File binaryPath;
        private Boolean generate;

        private Builder() {
        }

        public Builder addTypeNames(List<String> typeNames) {
            this.typeNames.addAll(typeNames);
            return this;
        }

        public Builder addTypeName(String typeName) {
            this.typeNames.add((Object)typeName);
            return this;
        }

        public Builder setBooleanAsNumber(boolean booleanAsNumber) {
            this.booleanAsNumber = booleanAsNumber;
            return this;
        }

        public Builder setDebugEnabled(boolean debugEnabled) {
            this.debugEnabled = debugEnabled;
            return this;
        }

        public Builder setOutputFile(File outputFile) {
            this.outputFile = outputFile;
            return this;
        }

        public Builder setTemplateFile(File templateFile) {
            this.templateFile = templateFile;
            return this;
        }

        public Builder setBinaryPath(File binaryPath) {
            this.binaryPath = binaryPath;
            return this;
        }

        public Builder setGenerate(Boolean generate) {
            this.generate = generate;
            return this;
        }

        public RRDToolWriter build() {
            return new RRDToolWriter((ImmutableList<String>)this.typeNames.build(), this.booleanAsNumber, this.debugEnabled, this.outputFile.getPath(), this.templateFile.getPath(), this.binaryPath.getPath(), this.generate, null);
        }
    }
}

